/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class DisplacementOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public DisplacementOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int offset = this.instruction.getByteOp();
        int target = this.instruction.getRelativeOp();
        return "PC + $" + new HwByte((long)offset) + " -> $" + new HwWord((long)target);
    }

    @Override
    public boolean isAddress() {
        return false;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        return this.instruction.getRelativeOp();
    }

    @Override
    public boolean isIndirect() {
        return false;
    }
}

