/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectAddressOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public IndirectAddressOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int address = this.instruction.getWordOp();
        this.instruction.setAddress(address);
        int value = this.instruction.getWordOp();
        this.instruction.setAddress(old_address);
        return "($" + new HwWord((long)address) + ") -> $" + new HwWord((long)value);
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int address = this.instruction.getWordOp();
        this.instruction.setAddress(address);
        int value = this.instruction.getWordOp();
        this.instruction.setAddress(old_address);
        return value;
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

