/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class IndirectYOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public IndirectYOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int zp_addr = this.instruction.getByteOp();
        this.instruction.setAddress(zp_addr);
        int ptr = this.instruction.getWordOp();
        int reg_y = cpu_state.getValue("Y");
        int address = ptr + reg_y;
        this.instruction.setAddress(address);
        int value = this.instruction.getByteOp();
        String result = "(($" + new HwByte((long)zp_addr) + ") + Y -> $" + new HwWord((long)ptr) + " + $" + new HwByte((long)reg_y) + " -> $" + new HwWord((long)address) + ") -> $" + new HwByte((long)value);
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int zp_addr = this.instruction.getByteOp();
        this.instruction.setAddress(zp_addr);
        int ptr = this.instruction.getWordOp();
        int reg_y = cpu_state.getValue("Y");
        int address = ptr + reg_y;
        this.instruction.setAddress(old_address);
        return address;
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

