/*
 * Decompiled with CFR 0.152.
 */
package emulator.support;

import emulator.hardware.HwByte;
import emulator.support.CpuState;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class ZeroPageXOperandEval
implements OperandEval {
    MemoryPtr instruction;

    public ZeroPageXOperandEval(MemoryPtr ptr) {
        this.instruction = ptr;
    }

    @Override
    public String getDetails(CpuState cpu_state) {
        int old_address = this.instruction.getAddress();
        int reg_x = cpu_state.getValue("X");
        int operand = this.instruction.getByteOp();
        this.instruction.setAddress(operand + reg_x & 0xFF);
        String result = "($" + new HwByte((long)operand) + " + $" + new HwByte((long)reg_x) + ") -> $" + new HwByte((long)this.instruction.getByteOp());
        this.instruction.setAddress(old_address);
        return result;
    }

    @Override
    public boolean isAddress() {
        return true;
    }

    @Override
    public int getAddress(CpuState cpu_state) {
        return this.instruction.getByteOp() + cpu_state.getValue("X") & 0xFF;
    }

    @Override
    public boolean isIndirect() {
        return false;
    }
}

