/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.analyzer;

import emulator.EmulatorException;
import emulator.analyzer.AddressDefinition;
import emulator.analyzer.CpuExecutionAnalyzer;
import emulator.hardware.HwWord;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.video.test.NullClock;
import emulator.util.AddressRange;
import emulator.util.MemoryHelper;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CpuExecutionAnalyzerTest {
    static final int CODE_SIZE = 16;
    static final int MEM_SIZE = 32;
    private MemoryBlock memory = new MemoryBlock(32);
    private NullClock clock = new NullClock();
    private Cpu6502 cpu = new Cpu6502();
    private CpuExecutionAnalyzer analyzer;

    @Before
    public void setUp() throws Exception {
        AddressRange code_range = new AddressRange(0, 16);
        this.analyzer = new CpuExecutionAnalyzer(this.memory, code_range, null);
        this.cpu.attach(this.memory, this.clock);
    }

    @Test
    public void testAnalyzeIndirectJump() throws EmulatorException {
        byte[] byArray = new byte[5];
        byArray[0] = 35;
        byArray[1] = 1;
        byArray[2] = 108;
        MemoryHelper.putData(this.memory, 0, byArray);
        this.cpu.setPC(2);
        this.analyzer.notifyPreExecute(this.cpu);
        this.checkDefinition(this.analyzer.getAddressMap(), 0, 2, 291, "Referenced address (low)");
        this.checkDefinition(this.analyzer.getAddressMap(), 1, 3, 291, "Referenced address (high)");
        this.checkDefinition(this.analyzer.getAddressMap(), 3, 1, 0, "Operand address");
        Assert.assertEquals((long)3L, (long)this.analyzer.getAddressMap().size());
    }

    @Test
    public void testAnalyzeDirectJump() throws EmulatorException {
        byte[] byArray = new byte[3];
        byArray[0] = 76;
        byArray[1] = 4;
        MemoryHelper.putData(this.memory, 0, byArray);
        this.cpu.setPC(0);
        this.analyzer.notifyPreExecute(this.cpu);
        this.checkDefinition(this.analyzer.getAddressMap(), 1, 1, 4, "Operand address");
        Assert.assertEquals((long)1L, (long)this.analyzer.getAddressMap().size());
    }

    @Test
    public void testAnalyzeDirectJumpModified() throws EmulatorException {
        byte[] byArray = new byte[8];
        byArray[0] = -87;
        byArray[1] = 4;
        byArray[2] = -115;
        byArray[3] = 6;
        byArray[5] = 76;
        MemoryHelper.putData(this.memory, 0, byArray);
        this.cpu.setPC(0);
        this.analyzer.notifyPreExecute(this.cpu);
        this.cpu.next();
        this.analyzer.notifyPreExecute(this.cpu);
        this.cpu.next();
        this.analyzer.notifyPreExecute(this.cpu);
        this.checkDefinition(this.analyzer.getAddressMap(), 3, 1, 6, "Modified location");
        this.checkDefinition(this.analyzer.getAddressMap(), 6, 2, 4, "Operand address (low)");
        this.checkDefinition(this.analyzer.getAddressMap(), 7, 3, 4, "Operand address (high)");
        Assert.assertEquals((long)3L, (long)this.analyzer.getAddressMap().size());
    }

    @Test
    public void testAnalyzeIndirectJumpModified() throws EmulatorException {
        byte[] byArray = new byte[10];
        byArray[0] = 35;
        byArray[1] = 1;
        byArray[2] = -87;
        byArray[3] = 4;
        byArray[4] = -115;
        byArray[7] = 108;
        MemoryHelper.putData(this.memory, 0, byArray);
        this.cpu.setPC(2);
        this.analyzer.notifyPreExecute(this.cpu);
        this.cpu.next();
        this.analyzer.notifyPreExecute(this.cpu);
        this.cpu.next();
        this.analyzer.notifyPreExecute(this.cpu);
        this.analyzer.dumpStats(System.out, "");
        this.checkDefinition(this.analyzer.getAddressMap(), 5, 1, 0, "Modified location");
        this.checkDefinition(this.analyzer.getAddressMap(), 0, 2, 260, "Referenced address (low)");
        this.checkDefinition(this.analyzer.getAddressMap(), 1, 3, 260, "Referenced address (high)");
        this.checkDefinition(this.analyzer.getAddressMap(), 8, 1, 0, "Operand address");
        Assert.assertEquals((long)4L, (long)this.analyzer.getAddressMap().size());
    }

    private void checkDefinition(HashMap<Integer, AddressDefinition> address_map, int location, int type, int target_address, String description) {
        Assert.assertTrue((String)(String.valueOf(description) + " missing"), (boolean)address_map.containsKey(location));
        Assert.assertEquals((String)(String.valueOf(description) + " has type " + address_map.get(location).getTypeName()), (long)type, (long)address_map.get(location).getType());
        Assert.assertEquals((String)(String.valueOf(description) + " has wrong target: " + new HwWord((long)address_map.get(location).getFullAddress())), (long)target_address, (long)address_map.get(location).getFullAddress());
    }
}

