/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.memory.SparseMemory;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.unittest.hardware.nmos6502.MockMemory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Cpu6502Test {
    private Cpu6502 cpu;

    @Before
    public void setUp() {
        this.cpu = new Cpu6502();
        this.cpu.attach(new MockMemory(), null);
        this.cpu.setPC(0);
        this.cpu.setSP(new HwByte(127L));
    }

    @Test
    public void testFetchProgramByte() throws EmulatorException {
        Assert.assertEquals((long)0L, (long)this.cpu.fetchProgramByte());
        Assert.assertEquals((long)1L, (long)this.cpu.getPC());
    }

    @Test
    public void testFetchProgramWord() throws EmulatorException {
        Assert.assertEquals((long)256L, (long)this.cpu.fetchProgramWord());
        Assert.assertEquals((long)2L, (long)this.cpu.getPC());
    }

    @Test
    public void testReadByte() throws EmulatorException {
        Assert.assertEquals((long)205L, (long)this.cpu.readByte(4301));
    }

    @Test
    public void testReadWord() throws EmulatorException {
        Assert.assertEquals((long)52941L, (long)this.cpu.readWord(4301));
    }

    @Test
    public void testPushPop() throws EmulatorException {
        this.cpu.attach(new SparseMemory(), null);
        int target = 4660;
        this.cpu.pushAddress(target, 0);
        Assert.assertEquals((long)target, (long)this.cpu.popAddress());
    }
}

