/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.DEC;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class DECTest {
    @Test
    public void testDecPositive() throws EmulatorException {
        this.executeAndCheckDEC(63, 0);
    }

    @Test
    public void testDecNegative() throws EmulatorException {
        this.executeAndCheckDEC(0, 128);
    }

    @Test
    public void testDecZero() throws EmulatorException {
        this.executeAndCheckDEC(1, 2);
    }

    private void executeAndCheckDEC(int val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MockOperand operand = new MockOperand(val);
        new DEC().execute(cpu, operand);
        Assert.assertEquals((Object)new HwByte((long)(val - 1)), (Object)operand.getByte());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

