/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.INX;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class INXTest {
    @Test
    public void testIncPositive() throws EmulatorException {
        this.executeAndCheckINX(63, 0);
    }

    @Test
    public void testIncNegative() throws EmulatorException {
        this.executeAndCheckINX(127, 128);
    }

    @Test
    public void testIncZero() throws EmulatorException {
        this.executeAndCheckINX(255, 2);
    }

    private void executeAndCheckINX(int x_val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        cpu.setX(new HwByte((long)x_val));
        new INX().execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte((long)(x_val + 1)), (Object)cpu.getX());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

