/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.INY;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class INYTest {
    @Test
    public void testIncPositive() throws EmulatorException {
        this.executeAndCheckINY(63, 0);
    }

    @Test
    public void testIncNegative() throws EmulatorException {
        this.executeAndCheckINY(127, 128);
    }

    @Test
    public void testIncZero() throws EmulatorException {
        this.executeAndCheckINY(255, 2);
    }

    private void executeAndCheckINY(int x_val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        cpu.setY(new HwByte((long)x_val));
        new INY().execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte((long)(x_val + 1)), (Object)cpu.getY());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

