/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.JMP;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class JMPTest {
    @Test
    public void testExecute() throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MemoryBlock memory = new MemoryBlock(65536);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        cpu.setPC(6699);
        cpu.setSP(new HwByte(255L));
        JMP jmp = new JMP();
        jmp.execute(cpu, new MockOperand(65490L));
        Assert.assertEquals((Object)new HwByte(255L), (Object)cpu.getSP());
        Assert.assertEquals((Object)new HwWord(65490L), (Object)cpu.getPC());
    }
}

