/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.JSR;
import emulator.unittest.hardware.nmos6502.MockOperand;
import org.junit.Assert;
import org.junit.Test;

public class JSRTest {
    @Test
    public void testExecute() throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MemoryBlock memory = new MemoryBlock(65536);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        cpu.setPC(6699);
        cpu.setSP(new HwByte(255L));
        JSR jsr = new JSR();
        jsr.execute(cpu, new MockOperand(65490L));
        Assert.assertEquals((long)253L, (long)cpu.getSP().getNumber());
        Assert.assertEquals((long)65490L, (long)cpu.getPC());
        Assert.assertEquals((long)26L, (long)memory.read(511));
        Assert.assertEquals((long)42L, (long)memory.read(510));
    }
}

