/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.commands.RTS;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class RTSTest {
    @Test
    public void testExecute() throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MemoryBlock memory = new MemoryBlock(65536);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        cpu.setPC(65244);
        cpu.setSP(new HwByte(253L));
        memory.write(511, 26);
        memory.write(510, 42);
        RTS rts = new RTS();
        rts.execute(cpu, new NoOperand());
        Assert.assertEquals((long)255L, (long)cpu.getSP().getNumber());
        Assert.assertEquals((long)6699L, (long)cpu.getPC());
    }
}

