/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.TAX;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TAXTest {
    private Cpu6502 cpu;
    private TAX tax;

    @Before
    public void setUp() throws Exception {
        this.cpu = new Cpu6502();
        this.tax = new TAX();
    }

    @Test
    public void testTransferZero() throws EmulatorException {
        this.executeAndcheckTAX(0, 2);
    }

    @Test
    public void testTransferPositive() throws EmulatorException {
        this.executeAndcheckTAX(5, 0);
    }

    @Test
    public void testTransferNegative() throws EmulatorException {
        this.executeAndcheckTAX(129, 128);
    }

    private void executeAndcheckTAX(int target, int expected_flags) throws EmulatorException {
        this.cpu.setX(new HwByte(255L));
        this.cpu.setAccu(new HwByte((long)target));
        this.tax.execute(this.cpu, new NoOperand());
        Assert.assertEquals((long)target, (long)this.cpu.getX().getNumber());
        Assert.assertEquals((long)target, (long)this.cpu.getAccu().getNumber());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)this.cpu.getFlags());
    }
}

