/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AbsoluteXTest {
    @Test
    public void testADC() throws EmulatorException {
        int opcode = 125;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testAND() throws EmulatorException {
        int opcode = 61;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testASL() throws EmulatorException {
        int opcode = 30;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testCMP() throws EmulatorException {
        int opcode = 221;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testDEC() throws EmulatorException {
        int opcode = 222;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testEOR() throws EmulatorException {
        int opcode = 93;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testINC() throws EmulatorException {
        int opcode = 254;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testLDA() throws EmulatorException {
        int opcode = 189;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testLDY() throws EmulatorException {
        int opcode = 188;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testLSR() throws EmulatorException {
        int opcode = 94;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testORA() throws EmulatorException {
        int opcode = 29;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testROL() throws EmulatorException {
        int opcode = 62;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testROR() throws EmulatorException {
        int opcode = 126;
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)7L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testSBC() throws EmulatorException {
        int opcode = 253;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    @Test
    public void testSTA() throws EmulatorException {
        int opcode = 157;
        Assert.assertEquals((long)4L, (long)this.getCycles(opcode, false));
        Assert.assertEquals((long)5L, (long)this.getCycles(opcode, true));
    }

    private int getCycles(int opcode, boolean cross_page) throws EmulatorException {
        TimingTestBase test_base = new TimingTestBase();
        test_base.setRegisters(0, cross_page ? 192 : 0, 0, 0);
        test_base.setCommand(0, opcode, 68, 0);
        test_base.execute();
        return test_base.getElapsedCycles();
    }
}

