/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.timing;

import emulator.EmulatorException;
import emulator.unittest.hardware.nmos6502.timing.TimingTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImpliedTest {
    TimingTestBase test_base = null;

    @Before
    public void setUp() throws Exception {
        this.test_base = new TimingTestBase();
    }

    @Test
    public void testBRK() throws EmulatorException {
        this.test_base.resizeMemory(65536);
        Assert.assertEquals((long)7L, (long)this.getCycles(0));
    }

    @Test
    public void testCLC() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(24));
    }

    @Test
    public void testCLD() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(216));
    }

    @Test
    public void testCLI() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(88));
    }

    @Test
    public void testCLV() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(184));
    }

    @Test
    public void testDEX() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(202));
    }

    @Test
    public void testDEY() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(136));
    }

    @Test
    public void testINX() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(232));
    }

    @Test
    public void testINY() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(200));
    }

    @Test
    public void testNOP() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(234));
    }

    @Test
    public void testPHA() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(72));
    }

    @Test
    public void testPHP() throws EmulatorException {
        Assert.assertEquals((long)3L, (long)this.getCycles(8));
    }

    @Test
    public void testPLA() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(104));
    }

    @Test
    public void testPLP() throws EmulatorException {
        Assert.assertEquals((long)4L, (long)this.getCycles(40));
    }

    @Test
    public void testRTI() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(64));
    }

    @Test
    public void testRTS() throws EmulatorException {
        Assert.assertEquals((long)6L, (long)this.getCycles(96));
    }

    @Test
    public void testSEC() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(56));
    }

    @Test
    public void testSED() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(248));
    }

    @Test
    public void testSEI() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(120));
    }

    @Test
    public void testTAX() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(170));
    }

    @Test
    public void testTAY() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(168));
    }

    @Test
    public void testTSX() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(186));
    }

    @Test
    public void testTXA() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(138));
    }

    @Test
    public void testTXS() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(154));
    }

    @Test
    public void testTYA() throws EmulatorException {
        Assert.assertEquals((long)2L, (long)this.getCycles(152));
    }

    private int getCycles(int opcode) throws EmulatorException {
        this.test_base.setCommand(0, opcode, 0, 0);
        this.test_base.execute();
        return this.test_base.getElapsedCycles();
    }
}

