/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

import emulator.analyzer.util.RangeRelocation;
import emulator.util.AddressRange;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class AddressRangeList {
    List<AddressRange> the_list = new LinkedList<AddressRange>();

    public AddressRangeList(boolean[] address_field) {
        AddressRange range = null;
        int i = 0;
        while (i < address_field.length) {
            if (address_field[i]) {
                if (range == null) {
                    range = new AddressRange();
                    range.setStart(i);
                }
            } else if (range != null) {
                range.setEnd(i - 1);
                this.the_list.add(range);
                range = null;
            }
            ++i;
        }
        if (range != null) {
            range.setEnd(address_field.length - 1);
            this.the_list.add(range);
        }
    }

    public void dump(PrintStream out, String prefix) {
        if (this.the_list.isEmpty()) {
            out.println(String.valueOf(prefix) + "(none)");
        } else {
            for (AddressRange range : this.the_list) {
                out.println(String.valueOf(prefix) + range);
            }
        }
    }

    public void toRelocations(List<RangeRelocation> relocations, int base) {
        for (AddressRange range : this.the_list) {
            relocations.add(new RangeRelocation(range, base - range.getStart()));
            base += range.getWidth();
        }
    }

    public boolean isEmpty() {
        return this.the_list.isEmpty();
    }
}

