/*
 * Decompiled with CFR 0.152.
 */
package emulator.util.file;

import emulator.util.ByteHelper;
import emulator.util.file.FileInfo;
import emulator.util.file.FileLoadStrategy;
import emulator.util.file.FileLoadStrategySkipPrefix;
import emulator.util.file.FileSaveStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileInfoSid
implements FileInfo {
    private int block_size;
    private int start_address;
    private int data_offset;
    private int song_count;
    private int init_address;
    private int exec_address;
    private int start_song;
    private String title;
    private String author;
    private String year;

    public FileInfoSid(String file_name) {
        block16: {
            this.block_size = -1;
            this.start_address = -1;
            this.data_offset = -1;
            this.song_count = 1;
            this.init_address = 0;
            this.exec_address = 0;
            this.title = new String();
            this.author = new String();
            this.year = new String();
            File file = new File(file_name);
            this.block_size = -1;
            this.start_address = -1;
            this.data_offset = -1;
            this.start_song = 1;
            FileInputStream file_stream = null;
            try {
                try {
                    file_stream = new FileInputStream(file);
                    new HeaderReader().readHeader(file_stream);
                    this.block_size = (int)file.length() - this.data_offset;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (file_stream == null) break block16;
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (file_stream == null) break block16;
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (file_stream != null) {
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public int getFormat() {
        return 7;
    }

    @Override
    public int getBlockSize() {
        return this.block_size;
    }

    @Override
    public int getStartAddress() {
        return this.start_address;
    }

    @Override
    public FileLoadStrategy getLoadStrategy() {
        return this.data_offset < 0 ? null : new FileLoadStrategySkipPrefix(this.data_offset);
    }

    @Override
    public FileSaveStrategy getSaveStrategy() {
        return null;
    }

    public int getSongCount() {
        return this.song_count;
    }

    public int getInitAddress() {
        return this.init_address;
    }

    public int getExecAddress() {
        return this.exec_address;
    }

    public int getStartSong() {
        return this.start_song;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getYear() {
        return this.year;
    }

    class HeaderReader {
        int file_offset = 0;

        HeaderReader() {
        }

        void readHeader(FileInputStream file_stream) throws IOException {
            this.file_offset = 0;
            this.skipToPos(file_stream, 4);
            this.readWord(file_stream);
            FileInfoSid.this.data_offset = this.readWord(file_stream);
            FileInfoSid.this.start_address = this.readWord(file_stream);
            FileInfoSid.this.init_address = this.readWord(file_stream);
            FileInfoSid.this.exec_address = this.readWord(file_stream);
            FileInfoSid.this.song_count = this.readWord(file_stream);
            FileInfoSid.this.start_song = this.readWord(file_stream);
            this.skipToPos(file_stream, 22);
            FileInfoSid.this.title = this.readString(file_stream, 32);
            this.skipToPos(file_stream, 54);
            FileInfoSid.this.author = this.readString(file_stream, 32);
            this.skipToPos(file_stream, 86);
            FileInfoSid.this.year = this.readString(file_stream, 32);
            if (FileInfoSid.this.start_address == 0) {
                this.skipToPos(file_stream, FileInfoSid.this.data_offset);
                FileInfoSid.this.start_address = ByteHelper.readWord(file_stream);
                FileInfoSid fileInfoSid = FileInfoSid.this;
                fileInfoSid.data_offset = fileInfoSid.data_offset + 2;
            }
        }

        private int readWord(FileInputStream file_stream) throws IOException {
            int word = ByteHelper.readWordBE(file_stream);
            this.file_offset += 2;
            return word;
        }

        private String readString(FileInputStream file_stream, int str_len) throws IOException {
            String text = "";
            int i = 0;
            while (i < str_len) {
                ++this.file_offset;
                int ch = file_stream.read();
                if (ch <= 0) break;
                text = String.valueOf(text) + (char)ch;
                ++i;
            }
            return text;
        }

        private void skipToPos(FileInputStream file_stream, int target_pos) throws IOException {
            while (this.file_offset < target_pos) {
                file_stream.read();
                ++this.file_offset;
            }
        }
    }
}

