/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flume.Channel;
import org.apache.flume.ChannelFactory;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.Sink;
import org.apache.flume.SinkFactory;
import org.apache.flume.SinkProcessor;
import org.apache.flume.SinkRunner;
import org.apache.flume.Source;
import org.apache.flume.SourceFactory;
import org.apache.flume.SourceRunner;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.channel.ChannelSelectorFactory;
import org.apache.flume.channel.DefaultChannelFactory;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.file.SimpleNodeConfiguration;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.source.SourceConfiguration;
import org.apache.flume.node.NodeConfiguration;
import org.apache.flume.node.nodemanager.NodeConfigurationAware;
import org.apache.flume.sink.DefaultSinkFactory;
import org.apache.flume.sink.DefaultSinkProcessor;
import org.apache.flume.sink.SinkGroup;
import org.apache.flume.source.DefaultSourceFactory;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.status.StatusLogger;

public class FlumeConfigurationBuilder {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ChannelFactory channelFactory = new DefaultChannelFactory();
    private final SourceFactory sourceFactory = new DefaultSourceFactory();
    private final SinkFactory sinkFactory = new DefaultSinkFactory();

    public NodeConfiguration load(String name, Properties props, NodeConfigurationAware configurationAware) {
        FlumeConfiguration fconfig;
        SimpleNodeConfiguration conf = new SimpleNodeConfiguration();
        try {
            fconfig = new FlumeConfiguration(props);
            List errors = fconfig.getConfigurationErrors();
            if (errors.size() > 0) {
                boolean isError = false;
                for (FlumeConfigurationError error : errors) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Component: ").append(error.getComponentName()).append(" ");
                    sb.append("Key: ").append(error.getKey()).append(" ");
                    sb.append(error.getErrorType().name()).append(" - ").append(error.getErrorType().getError());
                    switch (error.getErrorOrWarning()) {
                        case ERROR: {
                            isError = true;
                            LOGGER.error(sb.toString());
                            break;
                        }
                        case WARNING: {
                            LOGGER.warn(sb.toString());
                        }
                    }
                }
                if (isError) {
                    throw new ConfigurationException("Unable to configure Flume due to errors");
                }
            }
        }
        catch (RuntimeException ex) {
            this.printProps(props);
            throw ex;
        }
        FlumeConfiguration.AgentConfiguration agentConf = fconfig.getConfigurationFor(name);
        if (agentConf != null) {
            this.loadChannels(agentConf, (NodeConfiguration)conf);
            this.loadSources(agentConf, (NodeConfiguration)conf);
            this.loadSinks(agentConf, (NodeConfiguration)conf);
        } else {
            LOGGER.warn("No configuration found for: {}", new Object[]{name});
        }
        return conf;
    }

    private void printProps(Properties props) {
        for (String key : new TreeSet<String>(props.stringPropertyNames())) {
            LOGGER.error(key + "=" + props.getProperty(key));
        }
    }

    protected void loadChannels(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) {
        Channel channel;
        LOGGER.info("Creating channels");
        Set channels = agentConf.getChannelSet();
        Map compMap = agentConf.getChannelConfigMap();
        for (String chName : channels) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(chName);
            if (comp == null) continue;
            channel = this.channelFactory.create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)channel, (ComponentConfiguration)comp);
            conf.getChannels().put(comp.getComponentName(), channel);
        }
        for (String ch : channels) {
            Context context = (Context)agentConf.getChannelContext().get(ch);
            if (context == null) continue;
            channel = this.channelFactory.create(ch, context.getString("type"));
            Configurables.configure((Object)channel, (Context)context);
            conf.getChannels().put(ch, channel);
            LOGGER.info("created channel " + ch);
        }
    }

    protected void loadSources(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) {
        ChannelProcessor channelProcessor;
        ChannelSelector selector;
        ChannelSelectorConfiguration selectorConfig;
        Source source;
        Set sources = agentConf.getSourceSet();
        Map compMap = agentConf.getSourceConfigMap();
        for (String sourceName : sources) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sourceName);
            if (comp == null) continue;
            SourceConfiguration config = (SourceConfiguration)comp;
            source = this.sourceFactory.create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)source, (ComponentConfiguration)config);
            Set channelNames = config.getChannels();
            ArrayList channels = new ArrayList();
            for (String chName : channelNames) {
                channels.add(conf.getChannels().get(chName));
            }
            selectorConfig = config.getSelectorConfiguration();
            selector = ChannelSelectorFactory.create(channels, (ChannelSelectorConfiguration)selectorConfig);
            channelProcessor = new ChannelProcessor(selector);
            Configurables.configure((Object)channelProcessor, (ComponentConfiguration)config);
            source.setChannelProcessor(channelProcessor);
            conf.getSourceRunners().put(comp.getComponentName(), SourceRunner.forSource((Source)source));
        }
        Map sourceContexts = agentConf.getSourceContext();
        for (String src : sources) {
            String[] channelNames;
            Context context = (Context)sourceContexts.get(src);
            if (context == null) continue;
            source = this.sourceFactory.create(src, context.getString("type"));
            ArrayList channels = new ArrayList();
            Configurables.configure((Object)source, (Context)context);
            for (String chName : channelNames = context.getString("channels").split("\\s+")) {
                channels.add(conf.getChannels().get(chName));
            }
            selectorConfig = context.getSubProperties("selector.");
            selector = ChannelSelectorFactory.create(channels, (Map)selectorConfig);
            channelProcessor = new ChannelProcessor(selector);
            Configurables.configure((Object)channelProcessor, (Context)context);
            source.setChannelProcessor(channelProcessor);
            conf.getSourceRunners().put(src, SourceRunner.forSource((Source)source));
        }
    }

    protected void loadSinks(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) {
        Sink sink;
        Set sinkNames = agentConf.getSinkSet();
        Map compMap = agentConf.getSinkConfigMap();
        HashMap<String, Sink> sinks = new HashMap<String, Sink>();
        for (String sinkName : sinkNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sinkName);
            if (comp == null) continue;
            SinkConfiguration config = (SinkConfiguration)comp;
            sink = this.sinkFactory.create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)sink, (ComponentConfiguration)config);
            sink.setChannel((Channel)conf.getChannels().get(config.getChannel()));
            sinks.put(comp.getComponentName(), sink);
        }
        Map sinkContexts = agentConf.getSinkContext();
        for (String sinkName : sinkNames) {
            Context context = (Context)sinkContexts.get(sinkName);
            if (context == null) continue;
            sink = this.sinkFactory.create(sinkName, context.getString("type"));
            Configurables.configure((Object)sink, (Context)context);
            sink.setChannel((Channel)conf.getChannels().get(context.getString("channel")));
            sinks.put(sinkName, sink);
        }
        this.loadSinkGroups(agentConf, sinks, conf);
    }

    protected void loadSinkGroups(FlumeConfiguration.AgentConfiguration agentConf, Map<String, Sink> sinks, NodeConfiguration conf) {
        Set sinkgroupNames = agentConf.getSinkgroupSet();
        Map compMap = agentConf.getSinkGroupConfigMap();
        HashMap<String, String> usedSinks = new HashMap<String, String>();
        for (String string : sinkgroupNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(string);
            if (comp == null) continue;
            SinkGroupConfiguration groupConf = (SinkGroupConfiguration)comp;
            List groupSinkList = groupConf.getSinks();
            ArrayList<Sink> groupSinks = new ArrayList<Sink>();
            for (String sink : groupSinkList) {
                Sink s = sinks.remove(sink);
                if (s == null) {
                    String sinkUser = (String)usedSinks.get(sink);
                    if (sinkUser != null) {
                        throw new ConfigurationException(String.format("Sink %s of group %s already in use by group %s", sink, string, sinkUser));
                    }
                    throw new ConfigurationException(String.format("Sink %s of group %s does not exist or is not properly configured", sink, string));
                }
                groupSinks.add(s);
                usedSinks.put(sink, string);
            }
            SinkGroup group = new SinkGroup(groupSinks);
            Configurables.configure((Object)group, (ComponentConfiguration)groupConf);
            conf.getSinkRunners().put(comp.getComponentName(), new SinkRunner(group.getProcessor()));
        }
        for (Map.Entry entry : sinks.entrySet()) {
            if (usedSinks.containsValue(entry.getKey())) continue;
            DefaultSinkProcessor pr = new DefaultSinkProcessor();
            ArrayList sinkMap = new ArrayList();
            sinkMap.add(entry.getValue());
            pr.setSinks(sinkMap);
            Configurables.configure((Object)pr, (Context)new Context());
            conf.getSinkRunners().put(entry.getKey(), new SinkRunner((SinkProcessor)pr));
        }
    }
}

