/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jmx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;

public class ClientEditConfigPanel
extends JPanel {
    private static final long serialVersionUID = -7544651740950723394L;
    private static final int HORIZONTAL_GAP = 20;
    private static final int ERR_MSG_INITIAL_BUFFER_SIZE = 2048;
    private static final int LOCATION_TEXT_COLS = 50;
    private static final int CONFIG_TEXT_COLS = 60;
    private static final int CONFIG_TEXT_ROWS = 20;
    private static final int BUFFER_SIZE = 2048;
    private JTextField locationTextField;
    private JLabel locationLabel;
    private JButton buttonSendLocation;
    private JButton buttonSendConfigText;
    private JTextArea configTextArea;
    private final LoggerContextAdminMBean contextAdmin;
    private final AbstractAction actionReconfigureFromLocation = new AbstractAction("Reconfigure from Location"){
        private static final long serialVersionUID = 6995219797596745774L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ClientEditConfigPanel.this.contextAdmin.setConfigLocationURI(ClientEditConfigPanel.this.locationTextField.getText());
                ClientEditConfigPanel.this.populateWidgets();
                ClientEditConfigPanel.this.showConfirmation();
            }
            catch (Exception ex) {
                ClientEditConfigPanel.this.populateWidgets();
                ClientEditConfigPanel.this.handle("Could not reconfigure from location", ex);
            }
        }
    };
    private final AbstractAction actionReconfigureFromText = new AbstractAction("Reconfigure with XML Below"){
        private static final long serialVersionUID = -2846103707134292312L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String encoding = System.getProperty("file.encoding");
            try {
                ClientEditConfigPanel.this.contextAdmin.setConfigText(ClientEditConfigPanel.this.configTextArea.getText(), encoding);
                ClientEditConfigPanel.this.populateWidgets();
                ClientEditConfigPanel.this.showConfirmation();
            }
            catch (Exception ex) {
                ClientEditConfigPanel.this.populateWidgets();
                ClientEditConfigPanel.this.handle("Could not reconfigure from XML", ex);
            }
        }
    };

    public ClientEditConfigPanel(LoggerContextAdminMBean contextAdmin) {
        this.contextAdmin = contextAdmin;
        this.createWidgets();
        this.populateWidgets();
    }

    private void handle(String msg, Exception ex) {
        StringWriter sr = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sr);
        pw.println("Please check the StatusLogger tab for details");
        pw.println();
        ex.printStackTrace(pw);
        JOptionPane.showMessageDialog(this, sr.toString(), msg, 0);
    }

    private void showConfirmation() {
        JOptionPane.showMessageDialog(this, "Reconfiguration complete.", "Reconfiguration complete", 1);
    }

    private void populateWidgets() {
        try {
            this.configTextArea.setText(this.contextAdmin.getConfigText());
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter(2048);
            ex.printStackTrace(new PrintWriter(sw));
            this.configTextArea.setText(sw.toString());
        }
        String uri = this.contextAdmin.getConfigLocationURI();
        this.locationTextField.setText(uri);
    }

    private void createWidgets() {
        this.configTextArea = new JTextArea(20, 60);
        this.configTextArea.setBackground(Color.white);
        this.configTextArea.setForeground(Color.black);
        this.configTextArea.setFont(new Font("Monospaced", 0, this.configTextArea.getFont().getSize()));
        JScrollPane scrollConfig = new JScrollPane(this.configTextArea);
        this.locationTextField = new JTextField(50);
        this.locationLabel = new JLabel("Location: ");
        this.locationLabel.setLabelFor(this.locationTextField);
        this.buttonSendLocation = new JButton(this.actionReconfigureFromLocation);
        this.buttonSendConfigText = new JButton(this.actionReconfigureFromText);
        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, 2));
        north.add(this.locationLabel);
        north.add(this.locationTextField);
        north.add(this.buttonSendLocation);
        north.add(Box.createRigidArea(new Dimension(20, 0)));
        north.add(this.buttonSendConfigText);
        this.setLayout(new BorderLayout());
        this.add((Component)north, "North");
        this.add((Component)scrollConfig, "Center");
    }
}

