/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.APU;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.cheats.Patch;
import com.grapeshot.halfnes.mappers.Mapper;
import java.util.Arrays;
import java.util.HashMap;

public class CPURAM {
    private final int[] wram = new int[2048];
    Mapper mapper;
    public APU apu;
    PPU ppu;
    private HashMap<Integer, Patch> patches = new HashMap();

    public CPURAM(Mapper mappy) {
        this.mapper = mappy;
        Arrays.fill(this.wram, 255);
    }

    public final int read(int addr) {
        if (!this.patches.isEmpty()) {
            int retval = this._read(addr);
            Patch p = this.patches.get(addr);
            if (p != null && p.getAddress() == addr && p.matchesData(retval)) {
                return p.getData();
            }
            return retval;
        }
        return this._read(addr);
    }

    public final int _read(int addr) {
        if (addr > 16408) {
            return this.mapper.cartRead(addr);
        }
        if (addr <= 8191) {
            return this.wram[addr & 0x7FF];
        }
        if (addr <= 16383) {
            return this.ppu.read(addr & 7);
        }
        if (16384 <= addr && addr <= 16408) {
            return this.apu.read(addr - 16384);
        }
        return addr >> 8;
    }

    public final void write(int addr, int data) {
        if (addr > 16408) {
            this.mapper.cartWrite(addr, data);
        } else if (addr <= 8191) {
            this.wram[addr & 0x7FF] = data;
        } else if (addr <= 16383) {
            this.ppu.write(addr & 7, data);
        } else if (16384 <= addr && addr <= 16408) {
            this.apu.write(addr - 16384, data);
        }
    }

    public void setAPU(APU apu) {
        this.apu = apu;
    }

    public void setPPU(PPU ppu) {
        this.ppu = ppu;
    }

    public void setPatches(HashMap<Integer, Patch> p) {
        this.patches = p;
    }
}

