/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.APU;
import com.grapeshot.halfnes.CPU;
import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.FileUtils;
import com.grapeshot.halfnes.PPU;
import com.grapeshot.halfnes.ROMLoader;
import com.grapeshot.halfnes.cheats.ActionReplay;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.ui.ControllerInterface;
import com.grapeshot.halfnes.ui.FrameLimiterImpl;
import com.grapeshot.halfnes.ui.FrameLimiterInterface;
import com.grapeshot.halfnes.ui.GUIInterface;
import javafx.application.Platform;

public class NES {
    private Mapper mapper;
    private APU apu;
    private CPU cpu;
    private CPURAM cpuram;
    private PPU ppu;
    private GUIInterface gui;
    private ControllerInterface controller1;
    private ControllerInterface controller2;
    public static final String VERSION = "062";
    public boolean runEmulation = false;
    private boolean dontSleep = false;
    private boolean shutdown = false;
    public long frameStartTime;
    public long framecount;
    public long frameDoneTime;
    private boolean frameLimiterOn = true;
    private String curRomPath;
    private String curRomName;
    private final FrameLimiterInterface limiter = new FrameLimiterImpl(this, 16639267L);
    private ActionReplay actionReplay;

    public NES(GUIInterface gui) {
        if (gui != null) {
            this.gui = gui;
            gui.setNES(this);
            gui.run();
        }
    }

    public CPURAM getCPURAM() {
        return this.cpuram;
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public void run(String romtoload) {
        Thread.currentThread().setPriority(6);
        this.curRomPath = romtoload;
        this.gui.loadROMs(romtoload);
        this.run();
    }

    public void run() {
        while (!this.shutdown) {
            if (this.runEmulation) {
                this.frameStartTime = System.nanoTime();
                this.actionReplay.applyPatches();
                this.runframe();
                if (this.frameLimiterOn && !this.dontSleep) {
                    this.limiter.sleep();
                }
                this.frameDoneTime = System.nanoTime() - this.frameStartTime;
                continue;
            }
            this.limiter.sleepFixed();
            if (this.ppu == null || this.framecount <= 1L) continue;
            this.gui.render();
        }
    }

    private synchronized void runframe() {
        this.ppu.runFrame();
        this.dontSleep = this.apu.bufferHasLessThan(1000);
        this.apu.finishframe();
        this.cpu.modcycles();
        this.ppu.renderFrame(this.gui);
        if ((this.framecount & 0x7FFL) == 0L) {
            this.saveSRAM(true);
        }
        ++this.framecount;
    }

    public void setControllers(ControllerInterface controller1, ControllerInterface controller2) {
        this.controller1 = controller1;
        this.controller2 = controller2;
    }

    public void toggleFrameLimiter() {
        this.frameLimiterOn = !this.frameLimiterOn;
    }

    public synchronized void loadROM(String filename) {
        this.loadROM(filename, null);
    }

    public synchronized void loadROM(String filename, Integer initialPC) {
        this.runEmulation = false;
        if (FileUtils.exists(filename) && (FileUtils.getExtension(filename).equalsIgnoreCase(".nes") || FileUtils.getExtension(filename).equalsIgnoreCase(".nsf"))) {
            Mapper newmapper;
            try {
                ROMLoader loader = new ROMLoader(filename);
                loader.parseHeader();
                newmapper = Mapper.getCorrectMapper(loader);
                newmapper.setLoader(loader);
                newmapper.loadrom();
            }
            catch (BadMapperException e) {
                this.gui.messageBox("Error Loading File: ROM is corrupted or uses an unsupported mapper.\n" + e.getMessage());
                return;
            }
            catch (Exception e) {
                this.gui.messageBox("Error Loading File: ROM is corrupted or uses an unsupported mapper.\n" + e.toString() + e.getMessage());
                e.printStackTrace();
                return;
            }
            if (this.apu != null) {
                this.apu.destroy();
                this.saveSRAM(false);
                this.mapper.destroy();
                this.cpu = null;
                this.cpuram = null;
                this.ppu = null;
            }
            this.mapper = newmapper;
            this.cpuram = this.mapper.getCPURAM();
            this.actionReplay = new ActionReplay(this.cpuram);
            this.cpu = this.mapper.cpu;
            this.ppu = this.mapper.ppu;
            this.apu = new APU(this, this.cpu, this.cpuram);
            this.cpuram.setAPU(this.apu);
            this.cpuram.setPPU(this.ppu);
            this.curRomPath = filename;
            this.curRomName = FileUtils.getFilenamefromPath(filename);
            this.framecount = 0L;
            if (this.mapper.hasSRAM()) {
                this.loadSRAM();
            }
            this.cpu.init(initialPC);
            this.mapper.init();
            this.setParameters();
            this.runEmulation = true;
        } else {
            this.gui.messageBox("Could not load file:\nFile " + filename + "\n" + "does not exist or is not a valid NES game.");
        }
    }

    private void saveSRAM(boolean async) {
        if (this.mapper != null && this.mapper.hasSRAM() && this.mapper.supportsSaves()) {
            if (async) {
                FileUtils.asyncwritetofile(this.mapper.getPRGRam(), FileUtils.stripExtension(this.curRomPath) + ".sav");
            } else {
                FileUtils.writetofile(this.mapper.getPRGRam(), FileUtils.stripExtension(this.curRomPath) + ".sav");
            }
        }
    }

    private void loadSRAM() {
        String name = FileUtils.stripExtension(this.curRomPath) + ".sav";
        if (FileUtils.exists(name) && this.mapper.supportsSaves()) {
            this.mapper.setPRGRAM(FileUtils.readfromfile(name));
        }
    }

    public void quit() {
        if (this.cpu != null && this.curRomPath != null) {
            this.runEmulation = false;
            this.saveSRAM(false);
        }
        this.shutdown = true;
        Platform.exit();
    }

    public synchronized void reset() {
        if (this.cpu != null) {
            this.mapper.reset();
            this.cpu.reset();
            this.runEmulation = true;
            this.apu.pause();
            this.apu.resume();
        }
        this.framecount = 0L;
    }

    public synchronized void reloadROM() {
        this.loadROM(this.curRomPath);
    }

    public synchronized void pause() {
        if (this.apu != null) {
            this.apu.pause();
        }
        this.runEmulation = false;
    }

    public long getFrameTime() {
        return this.frameDoneTime;
    }

    public String getrominfo() {
        if (this.mapper != null) {
            return this.mapper.getrominfo();
        }
        return null;
    }

    public synchronized void frameAdvance() {
        this.runEmulation = false;
        if (this.cpu != null) {
            this.runframe();
        }
    }

    public synchronized void resume() {
        if (this.apu != null) {
            this.apu.resume();
        }
        if (this.cpu != null) {
            this.runEmulation = true;
        }
    }

    public String getCurrentRomName() {
        return this.curRomName;
    }

    public boolean isFrameLimiterOn() {
        return this.frameLimiterOn;
    }

    public void messageBox(String string) {
        if (this.gui != null) {
            this.gui.messageBox(string);
        }
    }

    public ControllerInterface getcontroller1() {
        return this.controller1;
    }

    public ControllerInterface getcontroller2() {
        return this.controller2;
    }

    public synchronized void setParameters() {
        if (this.apu != null) {
            this.apu.setParameters();
        }
        if (this.ppu != null) {
            this.ppu.setParameters();
        }
        if (this.limiter != null && this.mapper != null) {
            switch (this.mapper.getTVType()) {
                default: {
                    this.limiter.setInterval(16639267L);
                    break;
                }
                case PAL: 
                case DENDY: {
                    this.limiter.setInterval(19997200L);
                }
            }
        }
    }

    public synchronized ActionReplay getActionReplay() {
        return this.actionReplay;
    }
}

