/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

public class FFT {
    int n;
    int m;
    double[] cos;
    double[] sin;

    public FFT(int n) {
        this.n = n;
        this.m = (int)(Math.log(n) / Math.log(2.0));
        if (n != 1 << this.m) {
            throw new RuntimeException("FFT length must be power of 2");
        }
        this.cos = new double[n / 2];
        this.sin = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            this.cos[i] = Math.cos(Math.PI * -2 * (double)i / (double)n);
            this.sin[i] = Math.sin(Math.PI * -2 * (double)i / (double)n);
        }
    }

    public void fft(double[] x, double[] y) {
        double t1;
        int n1;
        int i;
        int j = 0;
        int n2 = this.n / 2;
        for (i = 1; i < this.n - 1; ++i) {
            for (n1 = n2; j >= n1; j -= n1, n1 /= 2) {
            }
            if (i >= (j += n1)) continue;
            t1 = x[i];
            x[i] = x[j];
            x[j] = t1;
            t1 = y[i];
            y[i] = y[j];
            y[j] = t1;
        }
        n1 = 0;
        n2 = 1;
        for (i = 0; i < this.m; ++i) {
            n1 = n2;
            n2 += n2;
            int a = 0;
            for (j = 0; j < n1; ++j) {
                double c = this.cos[a];
                double s = this.sin[a];
                a += 1 << this.m - i - 1;
                for (int k = j; k < this.n; k += n2) {
                    t1 = c * x[k + n1] - s * y[k + n1];
                    double t2 = s * x[k + n1] + c * y[k + n1];
                    x[k + n1] = x[k] - t1;
                    y[k + n1] = y[k] - t2;
                    x[k] = x[k] + t1;
                    y[k] = y[k] + t2;
                }
            }
        }
    }
}

