/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;

public class Namco163SoundChip
implements ExpansionSoundChip {
    private final int[] registers = new int[128];
    private final int[] out = new int[8];
    private int numch;
    private int cycpos = 0;
    private int curch = 0;
    int lpaccum = 0;

    @Override
    public void clock(int cycles) {
        this.numch = 1 + (this.registers[127] >> 4 & 7);
        for (int i = 0; i < cycles; ++i) {
            ++this.cycpos;
            this.cycpos %= 15;
            if (this.cycpos != 0) continue;
            ++this.curch;
            this.curch %= this.numch;
            this.clock_channel(this.curch);
        }
    }

    private void clock_channel(int ch) {
        int off = 128 - 8 * (ch + 1);
        int phase = (this.registers[off + 5] << 16) + (this.registers[off + 3] << 8) + this.registers[off + 1];
        int f = ((this.registers[off + 4] & 3) << 16) + (this.registers[off + 2] << 8) + this.registers[off];
        int len = (64 - (this.registers[off + 4] >> 2)) * 4;
        if (len > 32 && this.registers[off + 4] != 0) {
            int i = 2;
            while (i << 2 < len) {
                if (this.registers[i - 2] == 0 && this.registers[i - 1] == 0 && this.registers[i] == 0) {
                    len = 32 - (this.registers[off + 4] & 0x1C);
                    break;
                }
                ++i;
            }
        }
        int wavestart = this.registers[off + 6];
        phase = (phase + f) % (len << 16);
        int volume = this.registers[off + 7] & 0xF;
        int output = (this.getWavefromRAM((phase >> 16) + wavestart & 0xFF) - 8) * volume;
        this.registers[off + 5] = phase >> 16 & 0xFF;
        this.registers[off + 3] = phase >> 8 & 0xFF;
        this.registers[off + 1] = phase & 0xFF;
        this.out[ch] = output * 16;
        this.output();
    }

    private int getWavefromRAM(int addr) {
        int b = this.registers[addr >> 1];
        return (addr & 1) != 0 ? b >> 4 : b & 0xF;
    }

    @Override
    public void write(int register, int data) {
        this.registers[register] = data;
    }

    public int read(int register) {
        return this.registers[register];
    }

    @Override
    public int getval() {
        return this.lpaccum << 2;
    }

    private void output() {
        int sample = 0;
        for (int i = 0; i < this.numch; ++i) {
            sample += this.out[i];
        }
        this.lpaccum = (int)((double)this.lpaccum - (double)(sample += this.lpaccum) * 0.0625);
    }
}

