/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper33
extends Mapper {
    int prgbank0;
    int prgbank1 = 0;
    int[] chrbank = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 49151) {
            super.cartWrite(addr, data);
        } else if (addr <= 40959) {
            switch (addr & 3) {
                case 0: {
                    this.prgbank0 = data;
                    this.setmirroring((data & 0x40) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
                    this.setbanks();
                    break;
                }
                case 1: {
                    this.prgbank1 = data;
                    this.setbanks();
                    break;
                }
                case 2: {
                    this.chrbank[0] = data;
                    this.setbanks();
                    break;
                }
                case 3: {
                    this.chrbank[1] = data;
                    this.setbanks();
                }
            }
        } else if (addr <= 49151) {
            switch (addr & 3) {
                case 0: {
                    this.chrbank[2] = data;
                    this.setbanks();
                    break;
                }
                case 1: {
                    this.chrbank[3] = data;
                    this.setbanks();
                    break;
                }
                case 2: {
                    this.chrbank[4] = data;
                    this.setbanks();
                    break;
                }
                case 3: {
                    this.chrbank[5] = data;
                    this.setbanks();
                }
            }
        }
    }

    private void setbanks() {
        int i;
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) & this.prgsize - 1;
        }
        this.setppubank(1, 4, this.chrbank[2]);
        this.setppubank(1, 5, this.chrbank[3]);
        this.setppubank(1, 6, this.chrbank[4]);
        this.setppubank(1, 7, this.chrbank[5]);
        this.setppubank(2, 0, this.chrbank[0]);
        this.setppubank(2, 2, this.chrbank[1]);
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (i + banksize * banknum) & this.chrsize - 1;
        }
    }
}

