/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.MMC3Mapper;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper47
extends MMC3Mapper {
    private int multibank = 1;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
        this.setbank6();
    }

    @Override
    public void cartWrite(int addr, int data) {
        int i;
        if (addr < 24576 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr >= 24576 && addr <= Short.MAX_VALUE) {
            this.multibank = data & 1;
            for (i = 0; i < 8; ++i) {
                this.prg_map[i + 8] = 1024 * (i + data * 8) % 131072 + this.multibank * 131072;
            }
            this.setbank6();
            this.setupchr();
            for (i = 1; i <= 8; ++i) {
                this.prg_map[32 - i] = 131072 - 1024 * i + this.multibank * 131072;
            }
        }
        if ((addr & 1) != 0) {
            if (addr >= 32768 && addr <= 40959) {
                if (this.whichbank <= 5) {
                    this.chrreg[this.whichbank] = data;
                    this.setupchr();
                } else if (this.whichbank == 6) {
                    this.bank6 = data;
                    this.setbank6();
                } else if (this.whichbank == 7) {
                    for (i = 0; i < 8; ++i) {
                        this.prg_map[i + 8] = 1024 * (i + data * 8) % 131072 + this.multibank * 131072;
                    }
                }
            } else if (addr < 40960 || addr > 49151) {
                if (addr >= 49152 && addr <= 57343) {
                    this.irqreload = true;
                } else if (addr >= 57344 && addr <= 65535) {
                    this.irqenable = true;
                }
            }
        } else if (addr >= 32768 && addr <= 40959) {
            this.whichbank = data & 7;
            this.prgconfig = (data & 0x40) != 0;
            this.chrconfig = (data & 0x80) != 0;
            this.setupchr();
            this.setbank6();
        } else if (addr >= 40960 && addr <= 49151) {
            if (this.scrolltype != Mapper.MirrorType.FOUR_SCREEN_MIRROR) {
                this.setmirroring((data & 1) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
            }
        } else if (addr >= 49152 && addr <= 57343) {
            this.irqctrreload = data;
        } else if (addr >= 57344 && addr <= 65535) {
            if (this.interrupted) {
                --this.cpu.interrupt;
            }
            this.interrupted = false;
            this.irqenable = false;
        }
    }

    @Override
    protected void setbank6() {
        if (!this.prgconfig) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + this.bank6 * 8) % 131072 + this.multibank * 131072;
                this.prg_map[i + 16] = 114688 + 1024 * (i + this.multibank * 128);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 114688 + 1024 * (i + this.multibank * 128);
                this.prg_map[i + 16] = 1024 * (i + this.bank6 * 8) % 131072 + this.multibank * 131072;
            }
        }
    }

    @Override
    protected void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % (this.chrsize / 2) + this.multibank * 131072;
        }
    }
}

