/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.audio.Namco163SoundChip;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import java.util.Arrays;

public class NamcoMapper
extends Mapper {
    private int soundAddr = 0;
    private boolean autoincrement = false;
    private boolean irqenable = false;
    private boolean interrupted = false;
    private boolean chrramenable0 = false;
    private boolean chrramenable1 = false;
    Namco163SoundChip sound = new Namco163SoundChip();
    private boolean hasInitSound = false;
    private int irqcounter = 16383;
    private int[] chrbanks = new int[8];
    private int[] chr_ram = new int[16384];

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public int cartRead(int addr) {
        if (addr >= 18432 && addr < 20480) {
            if (!this.hasInitSound) {
                this.cpuram.apu.addExpnSound(this.sound);
                this.hasInitSound = true;
            }
            int retval = this.sound.read(this.soundAddr);
            if (this.autoincrement) {
                ++this.soundAddr;
                this.soundAddr &= 0x7F;
            }
            return retval;
        }
        if (addr < 22528) {
            this.irqack();
            return this.irqcounter & 0xFF;
        }
        if (addr < 24576) {
            this.irqack();
            return this.irqcounter >> 8 & 0x7F | (this.irqenable ? 128 : 0);
        }
        if (addr >= 32768) {
            return this.prg[this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF)];
        }
        if (addr >= 24576 && this.hasprgram) {
            return this.prgram[addr & 0x1FFF];
        }
        return addr >> 8;
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 18432 || addr >= 24576 && addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr <= 20479) {
            if (!this.hasInitSound) {
                this.cpuram.apu.addExpnSound(this.sound);
                this.hasInitSound = true;
            }
            this.sound.write(this.soundAddr, data);
            if (this.autoincrement) {
                ++this.soundAddr;
                this.soundAddr &= 0x7F;
            }
        } else if (addr <= 22527) {
            this.irqcounter &= 0x7F00;
            this.irqcounter |= data;
            this.irqack();
        } else if (addr <= 24575) {
            this.irqcounter &= 0xFF;
            this.irqcounter |= (data & 0x7F) << 8;
            this.irqenable = (data & 0x80) != 0;
            this.irqack();
        } else if (addr <= 49151) {
            int bank = addr >> 11 & 7;
            this.setppubank(1, bank, data);
            this.chrbanks[bank] = data;
        } else if (addr <= 51199) {
            this.nt0 = data < 224 ? Arrays.copyOfRange(this.chr, data * 1024, (data + 1) * 1024) : ((data & 1) != 0 ? this.pput1 : this.pput0);
        } else if (addr <= 51455) {
            this.nt1 = data < 224 ? Arrays.copyOfRange(this.chr, data * 1024, (data + 1) * 1024) : ((data & 1) != 0 ? this.pput1 : this.pput0);
        } else if (addr <= 55295) {
            this.nt2 = data < 224 ? Arrays.copyOfRange(this.chr, data * 1024, (data + 1) * 1024) : ((data & 1) != 0 ? this.pput1 : this.pput0);
        } else if (addr <= 57343) {
            this.nt3 = data < 224 ? Arrays.copyOfRange(this.chr, data * 1024, (data + 1) * 1024) : ((data & 1) != 0 ? this.pput1 : this.pput0);
        } else if (addr <= 59391) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + 8 * (data & 0x3F)) % this.prgsize;
            }
        } else if (addr <= 61439) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i + 8] = 1024 * (i + 8 * (data & 0x3F)) % this.prgsize;
            }
            this.chrramenable0 = (data & 0x40) == 0;
            this.chrramenable1 = (data & 0x80) == 0;
        } else if (addr <= 63487) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i + 16] = 1024 * (i + 8 * (data & 0x3F)) % this.prgsize;
            }
        } else if (addr <= 65535) {
            this.autoincrement = (data & 0x80) != 0;
            this.soundAddr = data & 0x7F;
        }
    }

    private void irqack() {
        if (this.interrupted) {
            --this.cpu.interrupt;
            this.interrupted = false;
        }
    }

    @Override
    public void cpucycle(int cycles) {
        this.irqcounter += cycles;
        if (this.irqcounter > Short.MAX_VALUE) {
            this.irqcounter = Short.MAX_VALUE;
        }
        if (this.irqcounter == Short.MAX_VALUE && this.irqenable && !this.interrupted) {
            ++this.cpu.interrupt;
            this.interrupted = true;
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) & this.chrsize - 1;
        }
    }

    @Override
    public int ppuRead(int addr) {
        if (addr < 4096) {
            if (this.chrramenable0 && this.chrbanks[addr >> 10] > 224) {
                return this.chr_ram[this.chr_map[addr >> 10] + (addr & 0x3FF)];
            }
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        if (addr < 8192) {
            if (this.chrramenable1 && this.chrbanks[addr >> 10] > 224) {
                return this.chr_ram[this.chr_map[addr >> 10] - 229376 + (addr & 0x3FF)];
            }
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        return super.ppuRead(addr);
    }

    @Override
    public void ppuWrite(int addr, int data) {
        if ((addr &= 0x3FFF) < 4096) {
            if (this.chrramenable0 && this.chrbanks[addr >> 10] > 224) {
                this.chr_ram[this.chr_map[addr >> 10] - 229376 + (addr & 0x3FF)] = data;
            } else {
                this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)] = data;
            }
        } else if (addr < 8192) {
            if (this.chrramenable1 && this.chrbanks[addr >> 10] > 224) {
                this.chr_ram[this.chr_map[addr >> 10] - 229376 + (addr & 0x3FF)] = data;
            } else {
                this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)] = data;
            }
        } else {
            super.ppuWrite(addr, data);
        }
    }
}

