/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class NromMapper
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        super.loadrom();
        int[] shiftedprg = new int[65536];
        System.arraycopy(this.prg, 0, shiftedprg, 32768, this.prg.length);
        if (this.prgsize <= 16384) {
            System.arraycopy(this.prg, 0, shiftedprg, 49152, this.prg.length);
        }
        this.prg = shiftedprg;
    }

    @Override
    public int cartRead(int addr) {
        if (addr >= 32768) {
            return this.prg[addr];
        }
        if (addr >= 24576 && this.hasprgram) {
            return this.prgram[addr & 0x1FFF];
        }
        return addr >> 8;
    }

    @Override
    public int ppuRead(int addr) {
        if (addr < 8192) {
            return this.chr[addr];
        }
        switch (addr & 0xC00) {
            case 0: {
                return this.nt0[addr & 0x3FF];
            }
            case 1024: {
                return this.nt1[addr & 0x3FF];
            }
            case 2048: {
                return this.nt2[addr & 0x3FF];
            }
        }
        if (addr >= 16128) {
            if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                addr -= 16;
            }
            return this.ppu.pal[addr];
        }
        return this.nt3[addr & 0x3FF];
    }
}

