/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.audio.VRC7SoundChip;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class VRC7Mapper
extends Mapper {
    int prgbank0;
    int prgbank1;
    int prgbank2;
    int[] chrbank = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    boolean irqmode;
    boolean irqenable;
    boolean irqack;
    boolean firedinterrupt = false;
    int irqreload;
    int irqcounter = 22;
    int regaddr = 0;
    ExpansionSoundChip sndchip = new VRC7SoundChip();
    boolean hasInitSound = false;
    int prescaler = 341;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = (this.prgsize - 1024 * i) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        boolean bit0 = (addr & 0x10) != 0 | (addr & 8) != 0;
        boolean bit1 = (addr & 0x20) != 0;
        switch (addr >> 12) {
            case 8: {
                if (bit0) {
                    this.prgbank1 = data;
                } else {
                    this.prgbank0 = data;
                }
                this.setbanks();
                break;
            }
            case 9: {
                if (!bit0 && !bit1) {
                    this.prgbank2 = data;
                    this.setbanks();
                    break;
                }
                if (bit0 && bit1) {
                    if (!this.hasInitSound) {
                        this.cpuram.apu.addExpnSound(this.sndchip);
                        this.hasInitSound = true;
                    }
                    this.sndchip.write(this.regaddr, data);
                    break;
                }
                this.regaddr = data;
                break;
            }
            case 10: {
                this.chrbank[bit0 ? 1 : 0] = data;
                this.setbanks();
                break;
            }
            case 11: {
                this.chrbank[(bit0 ? 1 : 0) + 2] = data;
                this.setbanks();
                break;
            }
            case 12: {
                this.chrbank[(bit0 ? 1 : 0) + 4] = data;
                this.setbanks();
                break;
            }
            case 13: {
                this.chrbank[(bit0 ? 1 : 0) + 6] = data;
                this.setbanks();
                break;
            }
            case 14: {
                if (bit0) {
                    this.irqreload = data;
                    break;
                }
                switch (data & 3) {
                    case 0: {
                        this.setmirroring(Mapper.MirrorType.V_MIRROR);
                        break;
                    }
                    case 1: {
                        this.setmirroring(Mapper.MirrorType.H_MIRROR);
                        break;
                    }
                    case 2: {
                        this.setmirroring(Mapper.MirrorType.SS_MIRROR0);
                        break;
                    }
                    case 3: {
                        this.setmirroring(Mapper.MirrorType.SS_MIRROR1);
                    }
                }
                break;
            }
            case 15: {
                if (bit0) {
                    this.irqenable = this.irqack;
                    if (this.firedinterrupt) {
                        --this.cpu.interrupt;
                    }
                    this.firedinterrupt = false;
                    break;
                }
                this.irqack = (data & 1) != 0;
                this.irqenable = (data & 2) != 0;
                boolean bl = this.irqmode = (data & 4) != 0;
                if (this.irqenable) {
                    this.irqcounter = this.irqreload;
                    this.prescaler = 341;
                }
                if (this.firedinterrupt) {
                    --this.cpu.interrupt;
                }
                this.firedinterrupt = false;
            }
        }
    }

    private void setbanks() {
        int i;
        for (i = 1; i <= 8; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 16] = 1024 * (i + 8 * this.prgbank2) % this.prgsize;
        }
        for (i = 0; i < 8; ++i) {
            this.setppubank(1, i, this.chrbank[i]);
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqenable) {
            if (this.irqmode) {
                this.scanlinecount();
            } else {
                this.prescaler -= 3;
                if (this.prescaler <= 0) {
                    this.prescaler += 341;
                    this.scanlinecount();
                }
            }
        }
    }

    public void scanlinecount() {
        if (this.irqenable) {
            if (this.irqcounter == 255) {
                this.irqcounter = this.irqreload;
                if (!this.firedinterrupt) {
                    ++this.cpu.interrupt;
                }
                this.firedinterrupt = true;
            } else {
                ++this.irqcounter;
            }
        }
    }
}

