/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.ui.GUIInterface;
import com.grapeshot.halfnes.ui.PuppetController;
import com.grapeshot.halfnes.video.RGBRenderer;
import com.grapeshot.halfnes.video.Renderer;
import java.awt.image.BufferedImage;

public class HeadlessUI
implements GUIInterface {
    private NES nes = new NES(this);
    private Renderer renderer;
    private boolean renderFrames;
    private BufferedImage lastFrame = null;
    private boolean updateImage;
    private PuppetController controller1;
    private PuppetController controller2;

    public HeadlessUI(String romToLoad, boolean renderFrames) {
        this.loadROM(romToLoad);
        this.renderer = new RGBRenderer();
        this.controller1 = new PuppetController();
        this.controller2 = new PuppetController();
        this.nes.setControllers(this.controller1, this.controller2);
        this.renderFrames = renderFrames;
    }

    public void loadROM(String romToLoad) {
        this.nes.loadROM(romToLoad);
    }

    public BufferedImage getLastFrame() {
        return this.lastFrame;
    }

    public PuppetController getController1() {
        return this.controller1;
    }

    public PuppetController getController2() {
        return this.controller2;
    }

    public synchronized void runFrame() {
        this.nes.frameAdvance();
    }

    public CPURAM getNESCPURAM() {
        return this.nes.getCPURAM();
    }

    @Override
    public NES getNes() {
        return this.nes;
    }

    @Override
    public void setNES(NES nes) {
        this.nes = nes;
    }

    @Override
    public void setFrame(int[] frame, int[] bgcolor, boolean dotcrawl) {
        if (this.renderFrames) {
            this.lastFrame = this.renderer.render(frame, bgcolor, dotcrawl);
        }
    }

    @Override
    public void messageBox(String message) {
        System.err.println(message);
    }

    @Override
    public void run() {
    }

    @Override
    public void render() {
    }

    @Override
    public void loadROMs(String path) {
    }
}

