/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.video;

public class NesColors {
    private static final double att = 0.7;
    public static final int[][] col = NesColors.GetNESColors();
    public static final byte[][][] colbytes = NesColors.NESColorsToBytes(col);

    private NesColors() {
    }

    private static int[][] GetNESColors() {
        int[] colorarray = new int[]{0x606060, 599694, 1708477, 3410358, 6162818, 7932217, 7277577, 5316361, 2701065, 870409, 609801, 609047, 604762, 0, 0, 0, 0xB1B1B1, 1464567, 0x4433FF, 8200447, 11867608, 13311347, 12986658, 9785097, 6255113, 2665481, 629769, 626738, 620194, 592137, 0, 0, 0xFFFFFF, 6139391, 10323199, 14117631, 0xFF5DFF, 16737222, 16744784, 16753933, 13419529, 7663625, 5569564, 3405953, 4183295, 0x494949, 0, 0, 0xFFFFFF, 13167359, 14801151, 0xFFCCFF, 0xFFC6FF, 0xFFCBFB, 16766914, 0xFFE999, 15792518, 14090128, 12451759, 11796439, 0xB3FFFF, 0xBCBCBC, 0, 0};
        int i = 0;
        while (i < colorarray.length) {
            int n = i++;
            colorarray[n] = colorarray[n] | 0xFF000000;
        }
        int[][] colors = new int[8][colorarray.length];
        for (int j = 0; j < colorarray.length; ++j) {
            int col = colorarray[j];
            int r = NesColors.r(col);
            int b = NesColors.b(col);
            int g = NesColors.g(col);
            colors[0][j] = col;
            colors[1][j] = NesColors.compose_col(r, (double)g * 0.7, (double)b * 0.7);
            colors[2][j] = NesColors.compose_col((double)r * 0.7, g, (double)b * 0.7);
            colors[3][j] = NesColors.compose_col(r, g, (double)b * 0.7);
            colors[4][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, b);
            colors[5][j] = NesColors.compose_col(r, (double)g * 0.7, b);
            colors[6][j] = NesColors.compose_col((double)r * 0.7, g, b);
            colors[7][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, (double)b * 0.7);
        }
        return colors;
    }

    private static byte[][][] NESColorsToBytes(int[][] col) {
        byte[][][] colbytes = new byte[col.length][][];
        for (int i = 0; i < col.length; ++i) {
            int[] col2 = col[i];
            byte[][] colbytes2 = colbytes[i] = new byte[col2.length][3];
            for (int j = 0; j < col2.length; ++j) {
                colbytes2[j][0] = (byte)NesColors.b(col2[j]);
                colbytes2[j][1] = (byte)NesColors.g(col2[j]);
                colbytes2[j][2] = (byte)NesColors.r(col2[j]);
            }
        }
        return colbytes;
    }

    private static int r(int col) {
        return col >> 16 & 0xFF;
    }

    private static int g(int col) {
        return col >> 8 & 0xFF;
    }

    private static int b(int col) {
        return col & 0xFF;
    }

    private static int compose_col(double r, double g, double b) {
        return (((int)r & 0xFF) << 16) + (((int)g & 0xFF) << 8) + ((int)b & 0xFF) + -16777216;
    }
}

