/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;

public class FDSSoundChip
implements ExpansionSoundChip {
    boolean regEnable = true;
    int[] wavetable = new int[64];
    int waveAddr;
    int waveOut;
    int waveAccum;
    boolean waveWriteEnable;
    boolean volEnvDirection;
    boolean volEnvDisable;
    boolean modEnvDirection;
    boolean modEnvDisable;
    int volEnvSpeed;
    int modEnvSpeed;
    int envClockMultiplier = 232;
    int pitch;
    boolean modDisable;
    int modCtr;
    int modFreq;
    int modAccum;
    int[] modTable = new int[64];
    int modTableAddr;
    int masterVol;
    int volGain;
    int modGain;
    int lpaccum;
    int modout;
    boolean BothEnvDisable;
    boolean haltWaveAndReset;
    int modEnvAccum;
    int volEnvAccum;

    @Override
    public void clock(int cycles) {
        for (int i = 0; i < cycles; ++i) {
            this.runUnits();
        }
    }

    private void runUnits() {
        if (this.pitch + this.modout > 0 && !this.haltWaveAndReset) {
            this.waveAccum += this.pitch + this.modout;
            if ((this.waveAccum & 0xFFFF) != this.waveAccum) {
                this.waveAccum &= 0xFFFF;
                this.waveAddr = this.waveAddr + 1 & 0x3F;
            }
        }
        if (this.modFreq > 0 && !this.modDisable) {
            this.modAccum += this.modFreq;
            if ((this.modAccum & 0xFFFF) != this.modAccum) {
                this.modAccum &= 0xFFFF;
                this.CalculateModulator();
            }
        } else if (this.modDisable) {
            this.modAccum = 0;
            this.modout = 0;
        }
        if (!this.haltWaveAndReset && !this.BothEnvDisable && this.envClockMultiplier != 0) {
            this.CalculateEnvelopes();
        }
        if (!this.waveWriteEnable) {
            this.waveOut = this.wavetable[this.waveAddr];
        }
        int tmp = this.volGain > 32 ? 32 : this.volGain;
        int out = this.waveOut * tmp;
        switch (this.masterVol) {
            default: {
                out *= 8;
                break;
            }
            case 1: {
                out *= 5;
                break;
            }
            case 2: {
                out *= 4;
                break;
            }
            case 3: {
                out *= 3;
            }
        }
        this.lpaccum -= (out += this.lpaccum) >> 6;
    }

    private void CalculateModulator() {
        switch (this.modTable[this.modTableAddr]) {
            default: {
                this.modCtr += 0;
                break;
            }
            case 1: {
                ++this.modCtr;
                break;
            }
            case 2: {
                this.modCtr += 2;
                break;
            }
            case 3: {
                this.modCtr += 4;
                break;
            }
            case 4: {
                this.modCtr = 0;
                break;
            }
            case 5: {
                this.modCtr -= 4;
                break;
            }
            case 6: {
                this.modCtr -= 2;
                break;
            }
            case 7: {
                --this.modCtr;
            }
        }
        ++this.modTableAddr;
        this.modTableAddr &= 0x3F;
        this.modCtr = this.modCtr << 25 >> 25;
        int temp = this.modCtr * this.modGain;
        int remainder = temp & 0xF;
        if (remainder > 0 && ((temp >>= 4) & 0x80) == 0) {
            temp = this.modCtr < 0 ? --temp : (temp += 2);
        }
        if (temp >= 192) {
            temp -= 256;
        } else if (temp < -64) {
            temp += 256;
        }
        temp = this.pitch * temp;
        remainder = temp & 0x3F;
        temp >>= 6;
        if (remainder >= 32) {
            ++temp;
        }
        this.modout = temp;
    }

    private void CalculateEnvelopes() {
        if (!this.modEnvDisable) {
            ++this.modEnvAccum;
            if (this.modEnvAccum > 8 * this.envClockMultiplier * (this.modEnvSpeed + 1)) {
                this.modEnvAccum = 0;
                if (this.modEnvDirection) {
                    if (this.modGain < 32) {
                        ++this.modGain;
                    }
                } else if (this.modGain > 0) {
                    --this.modGain;
                }
            }
        }
        if (!this.volEnvDisable) {
            ++this.volEnvAccum;
            if (this.volEnvAccum > 8 * this.envClockMultiplier * (this.volEnvSpeed + 1)) {
                this.volEnvAccum = 0;
                if (this.volEnvDirection) {
                    if (this.volGain < 32) {
                        ++this.volGain;
                    }
                } else if (this.volGain > 0) {
                    --this.volGain;
                }
            }
        }
    }

    @Override
    public void write(int register, int data) {
        if (register == 16419) {
            boolean bl = this.regEnable = (data & 1) != 0;
        }
        if (this.regEnable) {
            if (register >= 16448 && register <= 16511) {
                if (this.waveWriteEnable) {
                    this.wavetable[register - 16448 & 0x3F] = data & 0x3F;
                }
            } else if (register == 16512) {
                this.volEnvDisable = (data & 0x80) != 0;
                boolean bl = this.volEnvDirection = (data & 0x40) != 0;
                if (this.volEnvDisable) {
                    this.volGain = data & 0x3F;
                }
                this.volEnvSpeed = data & 0x3F;
                this.volEnvAccum = 0;
            } else if (register == 16514) {
                this.pitch &= 0xF00;
                this.pitch |= data & 0xFF;
            } else if (register == 16515) {
                this.pitch &= 0xFF;
                this.pitch |= (data & 0xF) << 8;
                boolean bl = this.haltWaveAndReset = (data & 0x80) != 0;
                if (this.haltWaveAndReset) {
                    this.waveAccum = 0;
                    this.waveAddr = 0;
                }
                this.BothEnvDisable = (data & 0x40) != 0;
            } else if (register == 16516) {
                this.modEnvDisable = (data & 0x80) != 0;
                boolean bl = this.modEnvDirection = (data & 0x40) != 0;
                if (this.modEnvDisable) {
                    this.modGain = data & 0x3F;
                }
                this.modEnvSpeed = data & 0x3F;
                this.modAccum = 0;
                this.modEnvAccum = 0;
            } else if (register == 16517) {
                this.modCtr = (data & 0x7F) << 25 >> 25;
            } else if (register == 16518) {
                this.modFreq &= 0xF00;
                this.modFreq |= data & 0xFF;
            } else if (register == 16519) {
                this.modFreq &= 0xFF;
                this.modFreq |= (data & 0xF) << 8;
                this.modDisable = (data & 0x80) != 0;
            } else if (register == 16520) {
                if (this.modDisable) {
                    for (int i = 0; i < 2; ++i) {
                        this.modTable[this.modTableAddr] = data & 7;
                        this.modTableAddr = this.modTableAddr + 1 & 0x3F;
                    }
                }
                this.modAccum = 0;
            } else if (register == 16521) {
                this.masterVol = data & 3;
                this.waveWriteEnable = (data & 0x80) != 0;
            } else if (register == 16522) {
                this.envClockMultiplier = data;
            }
        }
    }

    public int read(int register) {
        if (register >= 16448 && register < 16512) {
            return this.wavetable[register - 16448] | 0x40;
        }
        if (register == 16528) {
            return this.volGain;
        }
        if (register == 16530) {
            return this.modGain;
        }
        return 64;
    }

    @Override
    public int getval() {
        return this.lpaccum;
    }
}

