/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.PrefsSingleton;
import com.grapeshot.halfnes.audio.AudioOutInterface;
import com.grapeshot.halfnes.mappers.Mapper;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SwingAudioImpl
implements AudioOutInterface {
    private boolean soundEnable = PrefsSingleton.get().getBoolean("soundEnable", true);
    private SourceDataLine sdl;
    private byte[] audiobuf;
    private int bufptr = 0;
    private float outputvol = (float)((double)PrefsSingleton.get().getInt("outputvol", 13107) / 16384.0);

    public SwingAudioImpl(NES nes, int samplerate, Mapper.TVType tvtype) {
        double fps;
        switch (tvtype) {
            default: {
                fps = 60.0;
                break;
            }
            case PAL: 
            case DENDY: {
                fps = 50.0;
            }
        }
        if (this.soundEnable) {
            int samplesperframe = (int)Math.ceil((double)(samplerate * 2) / fps);
            this.audiobuf = new byte[samplesperframe * 2];
            try {
                AudioFormat af = new AudioFormat(samplerate, 16, 2, true, false);
                this.sdl = AudioSystem.getSourceDataLine(af);
                this.sdl.open(af, samplesperframe * 4 * 2 * 2);
                this.sdl.start();
            }
            catch (LineUnavailableException a) {
                System.err.println(a);
                nes.messageBox("Unable to inintialize sound.");
                this.soundEnable = false;
            }
            catch (IllegalArgumentException a) {
                System.err.println(a);
                nes.messageBox("Unable to inintialize sound.");
                this.soundEnable = false;
            }
        }
    }

    @Override
    public final void flushFrame(boolean waitIfBufferFull) {
        if (this.soundEnable) {
            if (this.sdl.available() < this.bufptr) {
                if (waitIfBufferFull) {
                    this.sdl.write(this.audiobuf, 0, this.bufptr);
                }
            } else {
                this.sdl.write(this.audiobuf, 0, this.bufptr);
            }
        }
        this.bufptr = 0;
    }

    @Override
    public final void outputSample(int sample) {
        if (this.soundEnable) {
            if ((sample = (int)((float)sample * this.outputvol)) < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            if (sample > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            }
            int lch = sample;
            this.audiobuf[this.bufptr] = (byte)(lch & 0xFF);
            this.audiobuf[this.bufptr + 1] = (byte)(lch >> 8 & 0xFF);
            int rch = sample;
            this.audiobuf[this.bufptr + 2] = (byte)(rch & 0xFF);
            this.audiobuf[this.bufptr + 3] = (byte)(rch >> 8 & 0xFF);
            this.bufptr += 4;
        }
    }

    @Override
    public void pause() {
        if (this.soundEnable) {
            this.sdl.flush();
            this.sdl.stop();
        }
    }

    @Override
    public void resume() {
        if (this.soundEnable) {
            this.sdl.start();
        }
    }

    @Override
    public final void destroy() {
        if (this.soundEnable) {
            this.sdl.stop();
            this.sdl.close();
        }
    }

    @Override
    public final boolean bufferHasLessThan(int samples) {
        return this.sdl == null ? false : this.sdl.getBufferSize() - this.sdl.available() <= samples;
    }
}

