/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper225
extends Mapper {
    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        this.setmirroring((addr & 0xD) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        int bank = addr >> 7 & 0x1F;
        if ((addr & 0x1000) != 0) {
            bank = bank << 1 | addr >> 6 & 1;
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * bank) & this.prgsize - 1;
            }
            for (i = 0; i < 16; ++i) {
                this.prg_map[i + 16] = 1024 * (i + 16 * bank) & this.prgsize - 1;
            }
        } else {
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * bank) & this.prgsize - 1;
            }
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * addr) & this.chrsize - 1;
        }
    }
}

