/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class Mapper48
extends Mapper {
    int prgbank0;
    int prgbank1 = 0;
    int[] chrbank = new int[]{0, 0, 0, 0, 0, 0};
    private int irqctrreload = 0;
    private int irqctr = 0;
    private boolean irqenable = false;
    private boolean irqreload = false;
    private boolean interrupted = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr <= 40959) {
            switch (addr & 3) {
                case 0: {
                    this.prgbank0 = data;
                    this.setbanks();
                    break;
                }
                case 1: {
                    this.prgbank1 = data;
                    this.setbanks();
                    break;
                }
                case 2: {
                    this.chrbank[0] = data;
                    this.setbanks();
                    break;
                }
                case 3: {
                    this.chrbank[1] = data;
                    this.setbanks();
                }
            }
        } else if (addr <= 49151) {
            switch (addr & 3) {
                case 0: {
                    this.chrbank[2] = data;
                    this.setbanks();
                    break;
                }
                case 1: {
                    this.chrbank[3] = data;
                    this.setbanks();
                    break;
                }
                case 2: {
                    this.chrbank[4] = data;
                    this.setbanks();
                    break;
                }
                case 3: {
                    this.chrbank[5] = data;
                    this.setbanks();
                }
            }
        } else if (addr <= 57343) {
            switch (addr & 3) {
                case 0: {
                    this.irqctrreload = data & 0xFF;
                    this.irqreload = true;
                    break;
                }
                case 1: {
                    this.irqctr = data;
                    this.irqreload = true;
                    break;
                }
                case 2: {
                    this.irqenable = true;
                    break;
                }
                case 3: {
                    if (this.interrupted) {
                        --this.cpu.interrupt;
                    }
                    this.interrupted = false;
                    this.irqenable = false;
                    this.irqctr = this.irqctrreload;
                }
            }
        } else if (addr <= 65535) {
            switch (addr & 3) {
                case 0: {
                    this.setmirroring((data & 0x40) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
                }
            }
        }
    }

    private void setbanks() {
        int i;
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) & this.prgsize - 1;
        }
        this.setppubank(1, 4, this.chrbank[2]);
        this.setppubank(1, 5, this.chrbank[3]);
        this.setppubank(1, 6, this.chrbank[4]);
        this.setppubank(1, 7, this.chrbank[5]);
        this.setppubank(2, 0, this.chrbank[0]);
        this.setppubank(2, 2, this.chrbank[1]);
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (i + banksize * banknum) & this.chrsize - 1;
        }
    }

    @Override
    public void notifyscanline(int scanline) {
        if (scanline > 239 && scanline != 261) {
            return;
        }
        if (!this.ppu.mmc3CounterClocking()) {
            return;
        }
        if (this.irqreload) {
            this.irqreload = false;
            this.irqctr = this.irqctrreload;
        }
        if (this.irqctr-- <= 0) {
            if (this.irqctrreload == 0) {
                return;
            }
            if (this.irqenable && !this.interrupted) {
                ++this.cpu.interrupt;
                this.interrupted = true;
            }
            this.irqctr = this.irqctrreload;
        }
    }
}

