/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class VRC1Mapper
extends Mapper {
    int prgbank0;
    int prgbank1;
    int prgbank2 = 0;
    int[] chrbank = new int[]{0, 0};

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 24; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 8; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        switch (addr >> 12) {
            case 8: {
                this.prgbank0 = data & 0xF;
                this.setbanks();
                break;
            }
            case 9: {
                this.setmirroring((data & 1) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
                this.chrbank[0] = this.chrbank[0] & 0xF | data << 3 & 0x10;
                this.chrbank[1] = this.chrbank[1] & 0xF | data << 2 & 0x10;
                this.setbanks();
                break;
            }
            case 10: {
                this.prgbank1 = data & 0xF;
                this.setbanks();
                break;
            }
            case 12: {
                this.prgbank2 = data & 0xF;
                this.setbanks();
                break;
            }
            case 14: {
                this.chrbank[0] = this.chrbank[0] & 0x10 | data & 0xF;
                this.setbanks();
                break;
            }
            case 15: {
                this.chrbank[1] = this.chrbank[1] & 0x10 | data & 0xF;
                this.setbanks();
            }
        }
    }

    private void setbanks() {
        int i;
        for (i = 1; i <= 8; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i] = 1024 * (i + 8 * this.prgbank0) % (this.prgsize - 1);
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 8] = 1024 * (i + 8 * this.prgbank1) % (this.prgsize - 1);
        }
        for (i = 0; i < 8; ++i) {
            this.prg_map[i + 16] = 1024 * (i + 8 * this.prgbank2) % (this.prgsize - 1);
        }
        this.setppubank(4, 0, this.chrbank[0]);
        this.setppubank(4, 4, this.chrbank[1]);
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (i + 4 * banknum) % (this.chrsize - 1);
        }
    }
}

