/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class VRC3Mapper
extends Mapper {
    private int irqctr;
    private int irqreload = 0;
    private boolean irqmode;
    private boolean irqenable;
    private boolean irqackenable;
    private boolean interrupted = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        switch (addr >> 12) {
            case 8: {
                this.irqreload = this.irqreload & 0xFFF0 | data & 0xF;
                break;
            }
            case 9: {
                this.irqreload = this.irqreload & 0xFF0F | (data & 0xF) << 4;
                break;
            }
            case 10: {
                this.irqreload = this.irqreload & 0xF0FF | (data & 0xF) << 8;
                break;
            }
            case 11: {
                this.irqreload = this.irqreload & 0xFFF | (data & 0xF) << 12;
                break;
            }
            case 12: {
                this.irqmode = (data & 4) != 0;
                this.irqackenable = (data & 1) != 0;
                boolean bl = this.irqenable = (data & 2) != 0;
                if (!this.irqenable) break;
                if (this.irqmode) {
                    this.irqctr &= 0xFF00;
                    this.irqctr |= this.irqreload & 0xFF;
                } else {
                    this.irqctr = this.irqreload;
                }
                if (!this.interrupted) break;
                --this.cpu.interrupt;
                this.interrupted = false;
                break;
            }
            case 13: {
                this.irqenable = this.irqackenable;
                if (!this.interrupted) break;
                --this.cpu.interrupt;
                this.interrupted = false;
                break;
            }
            case 15: {
                for (int i = 0; i < 16; ++i) {
                    this.prg_map[i] = 1024 * (i + 16 * (data & 0xF)) & this.prgsize - 1;
                }
                break;
            }
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqenable) {
            if (this.irqmode) {
                int temp = this.irqctr;
                this.irqctr &= 0xFF00;
                if (temp >= 255) {
                    this.irqctr = this.irqreload;
                    this.irqctr |= this.irqreload & 0xFF;
                    if (!this.interrupted) {
                        ++this.cpu.interrupt;
                        this.interrupted = true;
                    }
                } else {
                    this.irqctr |= (temp += cycles);
                }
            } else if (this.irqctr >= 65535) {
                this.irqctr = this.irqreload;
                if (!this.interrupted) {
                    ++this.cpu.interrupt;
                    this.interrupted = true;
                }
            } else {
                this.irqctr += cycles;
            }
        }
    }
}

