/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.JInputHelper;
import com.grapeshot.halfnes.NES;
import com.grapeshot.halfnes.ui.ControllerImpl;
import com.grapeshot.halfnes.ui.GUIInterface;
import com.grapeshot.halfnes.ui.OnScreenMenu;
import com.grapeshot.halfnes.video.NesColors;
import java.nio.ByteBuffer;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class JavaFXNES
extends Application
implements GUIInterface {
    private static final Insets overscan = new Insets(0.0, 0.0, 0.0, 0.0);
    private static final Insets extraOverscan = new Insets(8.0, 0.0, 8.0, 0.0);
    private NES nes;
    private Canvas gameCanvas;
    private Stage stage;
    private OnScreenMenu menu;
    final byte[] buffer = new byte[245760];
    final WritablePixelFormat<ByteBuffer> format = WritablePixelFormat.getByteBgraPreInstance();
    private final long[] frametimes = new long[60];
    private int frametimeptr = 0;
    private double fps;

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        Rectangle2D bounds = new Rectangle2D(0.0, 0.0, 640.0, 480.0);
        this.gameCanvas = new Canvas(256.0, 240.0);
        stage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> this.nes.quit());
        this.menu = new OnScreenMenu(this);
        this.menu.setPrefWidth(256.0);
        this.menu.setPrefHeight(240.0);
        Group root = new Group(new Node[]{this.gameCanvas, this.menu});
        Scene scene = new Scene((Parent)root, bounds.getWidth(), bounds.getHeight(), (Paint)Color.BLACK);
        stage.setScene(scene);
        stage.setFullScreenExitKeyCombination(KeyCombination.valueOf((String)"F11"));
        stage.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.menu.show();
            }
        });
        root.setLayoutX(overscan.getRight() - overscan.getLeft() - extraOverscan.getLeft() * bounds.getWidth() / 256.0);
        root.setLayoutY(overscan.getBottom() - overscan.getTop() - extraOverscan.getTop() * bounds.getHeight() / 240.0);
        root.getTransforms().add((Object)new Scale((bounds.getWidth() - (overscan.getRight() - overscan.getLeft())) / (256.0 - extraOverscan.getLeft() - extraOverscan.getRight()), (bounds.getHeight() - (overscan.getBottom() - overscan.getTop())) / (240.0 - extraOverscan.getTop() - extraOverscan.getBottom())));
        this.nes = new NES(this);
        ControllerImpl padController1 = new ControllerImpl(scene, 0);
        ControllerImpl padController2 = new ControllerImpl(scene, 1);
        padController1.startEventQueue();
        padController2.startEventQueue();
        this.nes.setControllers(padController1, padController2);
        List params = this.getParameters().getRaw();
        new Thread(() -> {
            if (params.isEmpty()) {
                this.nes.run();
            } else {
                this.nes.run((String)params.get(0));
            }
        }, "Game Thread").start();
    }

    public static void main(String[] args) {
        JInputHelper.setupJInput();
        JavaFXNES.launch((String[])args);
    }

    @Override
    public NES getNes() {
        return this.nes;
    }

    @Override
    public void setNES(NES nes) {
        this.nes = nes;
    }

    @Override
    public void setFrame(int[] nespixels, int[] bgcolor, boolean dotcrawl) {
        Platform.runLater(() -> {
            this.frametimes[this.frametimeptr] = this.nes.getFrameTime();
            ++this.frametimeptr;
            this.frametimeptr %= this.frametimes.length;
            if (this.frametimeptr == 0) {
                long averageframes = 0L;
                for (long l : this.frametimes) {
                    averageframes += l;
                }
                this.fps = 1.0E9 / (double)(averageframes /= (long)this.frametimes.length);
                this.stage.setTitle(String.format("HalfNES %s, %2.2f fps", "062", this.fps));
            }
            PixelWriter writer = this.gameCanvas.getGraphicsContext2D().getPixelWriter();
            for (int i = 0; i < nespixels.length; ++i) {
                byte[] colbytes = NesColors.colbytes[(nespixels[i] & 0x1C0) >> 6][nespixels[i] & 0x3F];
                System.arraycopy(colbytes, 0, this.buffer, i * 4, 3);
            }
            writer.setPixels(0, 0, 256, 240, this.format, this.buffer, 0, 1024);
        });
    }

    @Override
    public void messageBox(String message) {
        System.out.println("message = " + message);
    }

    @Override
    public void run() {
        Platform.runLater(() -> {
            this.stage.show();
            this.menu.show();
        });
    }

    @Override
    public void render() {
    }

    @Override
    public void loadROMs(String path) {
        this.menu.loadROMs(path);
    }
}

