/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class AfterburnerMapper
extends Mapper {
    private int bank = 0;
    boolean useromnt = false;
    int romnt1;
    int romnt2;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if (addr <= 36863) {
            this.setppubank(2, 0, data);
        } else if (addr <= 40959) {
            this.setppubank(2, 2, data);
        } else if (addr <= 45055) {
            this.setppubank(2, 4, data);
        } else if (addr <= 49151) {
            this.setppubank(2, 6, data);
        } else if (addr <= 53247) {
            this.romnt1 = data | 0x80;
        } else if (addr <= 57343) {
            this.romnt2 = data | 0x80;
        } else if (addr <= 61439) {
            this.useromnt = (data & 0x10) != 0;
            this.setmirroring((data & 1) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
        } else if (addr <= 65535) {
            this.bank = data & 0xF;
            for (int i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * this.bank) & this.prgsize - 1;
            }
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banksize * banknum + i) % this.chrsize;
        }
    }

    @Override
    public int ppuRead(int addr) {
        if (addr < 8192) {
            return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
        }
        switch (addr & 0xC00) {
            case 0: {
                return this.useromnt ? this.chr[(addr & 0x3FF) + this.romnt1 * 1024] : this.nt0[addr & 0x3FF];
            }
            case 1024: {
                return this.useromnt ? this.chr[(addr & 0x3FF) + this.romnt2 * 1024] : this.nt1[addr & 0x3FF];
            }
            case 2048: {
                return this.useromnt ? this.chr[(addr & 0x3FF) + this.romnt2 * 1024] : this.nt2[addr & 0x3FF];
            }
        }
        if (addr >= 16128) {
            if ((addr &= 0x1F) >= 16 && (addr & 3) == 0) {
                addr -= 16;
            }
            return this.ppu.pal[addr];
        }
        return this.useromnt ? this.chr[(addr & 0x3FF) + this.romnt1 * 1024] : this.nt3[addr & 0x3FF];
    }
}

