/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;

public class MMC3Mapper
extends Mapper {
    protected int whichbank = 0;
    protected boolean prgconfig = false;
    protected boolean chrconfig = false;
    protected int irqctrreload = 0;
    protected int irqctr = 0;
    protected boolean irqenable = false;
    protected boolean irqreload = false;
    protected int bank6 = 0;
    protected int[] chrreg = new int[]{0, 0, 0, 0, 0, 0};
    protected boolean interrupted = false;
    private boolean lastA12 = false;
    int a12timer = 0;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 1; i <= 32; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 0;
        }
        this.setbank6();
    }

    @Override
    public void cartWrite(int addr, int data) {
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        if ((addr & 1) != 0) {
            if (addr >= 32768 && addr <= 40959) {
                if (this.whichbank <= 5) {
                    this.chrreg[this.whichbank] = data;
                    this.setupchr();
                } else if (this.whichbank == 6) {
                    this.bank6 = data;
                    this.setbank6();
                } else if (this.whichbank == 7) {
                    for (int i = 0; i < 8; ++i) {
                        this.prg_map[i + 8] = 1024 * (i + data * 8) % this.prgsize;
                    }
                }
            } else if (addr < 40960 || addr > 49151) {
                if (addr >= 49152 && addr <= 57343) {
                    this.irqreload = true;
                } else if (addr >= 57344 && addr <= 65535) {
                    this.irqenable = true;
                }
            }
        } else if (addr >= 32768 && addr <= 40959) {
            this.whichbank = data & 7;
            this.prgconfig = (data & 0x40) != 0;
            this.chrconfig = (data & 0x80) != 0;
            this.setupchr();
            this.setbank6();
        } else if (addr >= 40960 && addr <= 49151) {
            if (this.scrolltype != Mapper.MirrorType.FOUR_SCREEN_MIRROR) {
                this.setmirroring((data & 1) != 0 ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
            }
        } else if (addr >= 49152 && addr <= 57343) {
            this.irqctrreload = data;
        } else if (addr >= 57344 && addr <= 65535) {
            if (this.interrupted) {
                --this.cpu.interrupt;
            }
            this.interrupted = false;
            this.irqenable = false;
        }
    }

    protected void setupchr() {
        if (this.chrconfig) {
            this.setppubank(1, 0, this.chrreg[2]);
            this.setppubank(1, 1, this.chrreg[3]);
            this.setppubank(1, 2, this.chrreg[4]);
            this.setppubank(1, 3, this.chrreg[5]);
            this.setppubank(2, 4, this.chrreg[0] >> 1 << 1);
            this.setppubank(2, 6, this.chrreg[1] >> 1 << 1);
        } else {
            this.setppubank(1, 4, this.chrreg[2]);
            this.setppubank(1, 5, this.chrreg[3]);
            this.setppubank(1, 6, this.chrreg[4]);
            this.setppubank(1, 7, this.chrreg[5]);
            this.setppubank(2, 0, this.chrreg[0] >> 1 << 1);
            this.setppubank(2, 2, this.chrreg[1] >> 1 << 1);
        }
    }

    protected void setbank6() {
        if (!this.prgconfig) {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = 1024 * (i + this.bank6 * 8) % this.prgsize;
                this.prg_map[i + 16] = this.prgsize - 16384 + 1024 * i;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.prg_map[i] = this.prgsize - 16384 + 1024 * i;
                this.prg_map[i + 16] = 1024 * (i + this.bank6 * 8) % this.prgsize;
            }
        }
    }

    @Override
    public int ppuRead(int addr) {
        this.checkA12(addr);
        return super.ppuRead(addr);
    }

    @Override
    public void ppuWrite(int addr, int data) {
        this.checkA12(addr);
        super.ppuWrite(addr, data);
    }

    @Override
    public void checkA12(int addr) {
        boolean a12;
        boolean bl = a12 = (addr & 0x1000) != 0;
        if (a12 && !this.lastA12) {
            if (this.a12timer <= 0) {
                this.clockScanCounter();
            }
        } else if (!a12 && this.lastA12) {
            this.a12timer = 8;
        }
        --this.a12timer;
        this.lastA12 = a12;
    }

    private void clockScanCounter() {
        if (this.irqreload || this.irqctr == 0) {
            this.irqctr = this.irqctrreload;
            this.irqreload = false;
        } else {
            --this.irqctr;
        }
        if (this.irqctr == 0 && this.irqenable && !this.interrupted) {
            ++this.cpu.interrupt;
            this.interrupted = true;
        }
    }

    protected void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }
}

