/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DebugUI
extends JFrame {
    private ShowFrame fbuf;
    private int xsize;
    private int ysize;
    private Repainter painter = new Repainter();

    public DebugUI(int height, int width) {
        this.xsize = height;
        this.ysize = width;
        this.fbuf = new ShowFrame();
        this.fbuf.setIgnoreRepaint(true);
    }

    public void run() {
        this.setTitle("HalfNES  Debug 062");
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.fbuf);
        this.pack();
        this.setVisible(true);
    }

    public void messageBox(String s) {
        JOptionPane.showMessageDialog(this.fbuf, s);
    }

    public void setFrame(BufferedImage b) {
        this.fbuf.nextFrame = b;
        EventQueue.invokeLater(this.painter);
    }

    public class ShowFrame
    extends JPanel {
        public BufferedImage nextFrame;

        public ShowFrame() {
            this.setBounds(0, 0, DebugUI.this.xsize, DebugUI.this.ysize);
            this.setPreferredSize(new Dimension(DebugUI.this.xsize, DebugUI.this.ysize));
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.nextFrame, 0, 0, DebugUI.this.xsize, DebugUI.this.ysize, null);
        }
    }

    public class Repainter
    implements Runnable {
        @Override
        public void run() {
            DebugUI.this.fbuf.repaint();
        }
    }
}

