/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.ui;

import com.grapeshot.halfnes.FileUtils;
import com.grapeshot.halfnes.ui.GUIInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class OnScreenMenu
extends StackPane {
    private GUIInterface gui;
    private ListView<MenuAction> menu;
    private ListView<MenuAction> gameMenu;
    private final ObservableList<MenuAction> menuItems = FXCollections.observableArrayList((Object[])new MenuAction[]{new MenuAction("Resume", this::resume), new MenuAction("Load Game", this::loadGame), new MenuAction("Reset", this::reset), new MenuAction("Exit", this::exit), new MenuAction("Power Off", this::powerOff)});
    private final ObservableList<MenuAction> games = FXCollections.observableArrayList((Object[])new MenuAction[]{new MenuAction("Back", () -> this.gameMenu.setVisible(false))});

    public OnScreenMenu(GUIInterface gui) {
        this.gui = gui;
        this.menu = new ListView(this.menuItems);
        this.gameMenu = new ListView(this.games);
        this.addMenuListeners(this.menu);
        this.addMenuListeners(this.gameMenu);
        this.getChildren().addAll((Object[])new Node[]{this.menu, this.gameMenu});
        this.gameMenu.setVisible(false);
        this.setVisible(false);
    }

    private void addMenuListeners(ListView<MenuAction> menu) {
        menu.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER) || e.getCode().equals((Object)KeyCode.SPACE)) {
                ((MenuAction)menu.getSelectionModel().getSelectedItem()).run();
            }
        });
        menu.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getClickCount() == 2) {
                ((MenuAction)menu.getSelectionModel().getSelectedItem()).run();
            }
        });
    }

    public void show() {
        this.gui.getNes().pause();
        this.setVisible(true);
    }

    private void hide() {
        this.setVisible(false);
    }

    public void loadROMs(String path) {
        if (path.toLowerCase().endsWith(".zip")) {
            try {
                this.loadRomFromZip(path);
            }
            catch (IOException ex) {
                this.gui.messageBox("Could not load file:\nFile does not exist or is not a valid NES game.\n" + ex.getMessage());
            }
        } else {
            this.games.add((Object)new GameAction(new File(path)));
            this.runGame(path);
        }
    }

    private void loadRomFromZip(String zipName) throws IOException {
        this.listRomsInZip(zipName).stream().map(romName -> new GameAction(zipName, (String)romName)).forEach(arg_0 -> this.games.add(arg_0));
        if (this.games.size() == 2) {
            ((MenuAction)this.games.get(1)).run();
        } else if (this.games.size() > 2) {
            Platform.runLater(() -> this.loadGame());
        }
    }

    private List<String> listRomsInZip(String zipName) throws IOException {
        ArrayList<String> romNames;
        try (ZipFile zipFile = new ZipFile(zipName);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            romNames = new ArrayList<String>();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".nes") && !entry.getName().endsWith(".fds") && !entry.getName().endsWith(".nsf")) continue;
                romNames.add(entry.getName());
            }
        }
        if (romNames.isEmpty()) {
            throw new IOException("No NES games found in ZIP file.");
        }
        return romNames;
    }

    private File extractRomFromZip(String zipName, String romName) throws IOException {
        FileOutputStream fos;
        File outputFile;
        try (ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipName));){
            int numBytes;
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null && !entry.getName().equals(romName)) {
            }
            if (entry == null) {
                zipStream.close();
                throw new IOException("Cannot find file " + romName + " inside archive " + zipName);
            }
            outputFile = new File(new File(zipName).getCanonicalFile().getParent() + File.separator + FileUtils.stripExtension(new File(zipName).getName()) + " - " + romName);
            if (outputFile.exists() && !outputFile.delete()) {
                this.gui.messageBox("Cannot extract file. File " + outputFile.getCanonicalPath() + " already exists.");
                zipStream.close();
                File file = null;
                return file;
            }
            byte[] buf = new byte[4096];
            fos = new FileOutputStream(outputFile);
            while ((numBytes = zipStream.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, numBytes);
            }
        }
        fos.close();
        return outputFile;
    }

    private void resume() {
        this.gui.getNes().resume();
        this.hide();
    }

    private void loadGame() {
        this.gameMenu.setVisible(true);
        this.gameMenu.requestFocus();
    }

    private void runGame(String path) {
        this.gui.getNes().loadROM(path);
        Platform.runLater(() -> {
            this.gameMenu.setVisible(false);
            this.hide();
        });
    }

    private void reset() {
        this.gui.getNes().reset();
        this.hide();
    }

    private void exit() {
        this.gui.getNes().quit();
        Platform.exit();
    }

    private void powerOff() {
    }

    class GameAction
    extends MenuAction {
        GameAction(File game) {
            this.name = game.getName();
            this.action = () -> {
                try {
                    OnScreenMenu.this.gui.getNes().loadROM(game.getCanonicalPath());
                    Platform.runLater(() -> {
                        OnScreenMenu.this.gameMenu.setVisible(false);
                        OnScreenMenu.this.menu.setVisible(false);
                    });
                }
                catch (IOException e) {
                    OnScreenMenu.this.gui.messageBox(e.getMessage());
                }
            };
        }

        GameAction(String zipName, String romName) {
            this.name = romName.toLowerCase().endsWith(".nes") ? romName.substring(0, romName.length() - 4) : romName;
            this.action = () -> {
                try {
                    File extractedFile = OnScreenMenu.this.extractRomFromZip(zipName, romName);
                    if (extractedFile != null) {
                        extractedFile.deleteOnExit();
                    }
                    OnScreenMenu.this.runGame(extractedFile.getCanonicalPath());
                }
                catch (IOException e) {
                    OnScreenMenu.this.gui.messageBox(e.getMessage());
                }
            };
        }
    }

    class MenuAction {
        String name;
        Runnable action;

        MenuAction() {
        }

        MenuAction(String name, Runnable action) {
            this.name = name;
            this.action = action;
        }

        public void run() {
            this.action.run();
        }

        public String toString() {
            return this.name;
        }
    }
}

