/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import java.util.Locale;

public class utils {
    public static final int BIT0 = 1;
    public static final int BIT1 = 2;
    public static final int BIT2 = 4;
    public static final int BIT3 = 8;
    public static final int BIT4 = 16;
    public static final int BIT5 = 32;
    public static final int BIT6 = 64;
    public static final int BIT7 = 128;
    public static final int BIT8 = 256;
    public static final int BIT9 = 512;
    public static final int BIT10 = 1024;
    public static final int BIT11 = 2048;
    public static final int BIT12 = 4096;
    public static final int BIT13 = 8192;
    public static final int BIT14 = 16384;
    public static final int BIT15 = 32768;

    private utils() {
    }

    public static int setbit(int num, int bitnum, boolean state) {
        return state ? num | 1 << bitnum : num & ~(1 << bitnum);
    }

    public static String hex(int num) {
        String s = Integer.toHexString(num).toUpperCase(Locale.US);
        if ((s.length() & 1) == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static String hex(long num) {
        String s = Long.toHexString(num).toUpperCase(Locale.US);
        if ((s.length() & 1) == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static int reverseByte(int nibble) {
        return Integer.reverse(nibble) >> 24 & 0xFF;
    }

    public static void printarray(int[] a) {
        StringBuilder s = new StringBuilder();
        for (int i : a) {
            s.append(i);
            s.append(", ");
        }
        if (s.length() >= 1) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("\n");
        System.err.print(s.toString());
    }

    public static void printarray(boolean[] a) {
        StringBuilder s = new StringBuilder();
        for (boolean i : a) {
            s.append(i);
            s.append(", ");
        }
        if (s.length() >= 1) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("\n");
        System.err.print(s.toString());
    }

    public static void printarray(double[] a) {
        StringBuilder s = new StringBuilder();
        for (double i : a) {
            s.append(i);
            s.append(", ");
        }
        if (s.length() >= 1) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("\n");
        System.err.print(s.toString());
    }

    public static void printarray(float[] a) {
        StringBuilder s = new StringBuilder();
        for (float i : a) {
            s.append(i);
            s.append(", ");
        }
        if (s.length() >= 1) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("\n");
        System.err.print(s.toString());
    }

    public static void printarray(Object[] a) {
        StringBuilder s = new StringBuilder();
        for (Object i : a) {
            s.append(i.toString());
            s.append(", ");
        }
        if (s.length() >= 1) {
            s.deleteCharAt(s.length() - 1);
        }
        s.append("\n");
        System.err.print(s.toString());
    }

    public static int max(int[] array) {
        int m = array[0];
        int[] nArray = array;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (i2 <= m) continue;
            m = i2;
        }
        return m;
    }
}

