/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.video;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public abstract class Renderer {
    int frame_width;
    int clip = 8;
    int height = 240 - 2 * this.clip;
    BufferedImage[] imgs = new BufferedImage[]{null, null, null, null};
    int imgctr = 0;

    protected final void init_images() {
        for (int i = 0; i < this.imgs.length; ++i) {
            this.imgs[i] = new BufferedImage(this.frame_width, this.height, 3);
        }
    }

    public abstract BufferedImage render(int[] var1, int[] var2, boolean var3);

    public void setClip(int i) {
        this.clip = i;
        this.height = 240 - 2 * this.clip;
    }

    public BufferedImage getBufferedImage(int[] frame) {
        BufferedImage image = this.imgs[++this.imgctr % this.imgs.length];
        WritableRaster raster = image.getRaster();
        int[] pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
        System.arraycopy(frame, this.frame_width * this.clip, pixels, 0, this.frame_width * this.height);
        return image;
    }
}

