/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import uk101.Main;
import uk101.hardware.Memory;

public class ROM
extends Memory {
    protected String name;
    private String romid;
    private String patches;

    public ROM(String id) throws IOException {
        this(id, true);
    }

    protected ROM(String id, boolean ro) throws IOException {
        super(ROM.load(ROM.findName(id)), ro);
        this.name = id;
        this.romid = new File(ROM.findName(id)).getName().toUpperCase();
        if (this.romid.lastIndexOf(46) != -1) {
            this.romid = this.romid.substring(0, this.romid.lastIndexOf(46));
        }
        this.patches = ROM.findPatch(id);
    }

    public String id() {
        return this.romid;
    }

    public void patch() {
        if (this.patches != null) {
            StringTokenizer t1 = new StringTokenizer(this.patches, "[];: ");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), "/,");
                if (!t2.hasMoreTokens()) continue;
                int addr = Integer.parseInt(t2.nextToken(), 16) - this.base;
                while (t2.hasMoreTokens()) {
                    this.store[addr++] = (byte)Integer.parseInt(t2.nextToken(), 16);
                }
            }
        }
    }

    private static byte[] load(String id) throws IOException {
        InputStream in;
        String rid = id.toUpperCase();
        if (!rid.endsWith(".ROM")) {
            rid = String.valueOf(rid) + ".ROM";
        }
        if ((in = Main.class.getResourceAsStream("rom/" + rid)) == null && (in = Main.class.getResourceAsStream("/" + id.toUpperCase())) == null && (in = Main.class.getResourceAsStream("/" + id)) == null) {
            in = new FileInputStream(id);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int b = in.read();
        while (b != -1) {
            out.write(b);
            b = in.read();
        }
        in.close();
        return out.toByteArray();
    }

    private static String findName(String id) {
        String name = id;
        if (id.indexOf(91) != -1) {
            name = id.substring(0, id.indexOf(91)).trim();
        }
        return name;
    }

    private static String findPatch(String id) {
        String patch = null;
        if (id.indexOf(91) != -1) {
            patch = id.substring(id.indexOf(91)).trim();
        }
        return patch;
    }

    public String toString() {
        return "ROM" + super.toString() + ": " + this.name;
    }
}

