/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.EOFException;
import java.io.IOException;
import uk101.io.AudioDecoder;

public class KansasCityDecoder
extends AudioDecoder {
    private int cycles0;
    private int cycles1;
    private int countHi;
    private int countLo;
    private boolean countAdapt;

    public KansasCityDecoder(int baud) {
        this(baud, 0);
    }

    public KansasCityDecoder(int baud, int phase) {
        super(phase);
        int n;
        this.cycles0 = n = 4 / (baud / 300);
        this.cycles1 = 2 * n;
    }

    public void setAdaptive(boolean adapt) {
        this.countAdapt = adapt;
    }

    public int decodeByte() throws IOException {
        int b = 0;
        try {
            b = this.decodeBit();
            while (b != 0) {
                b = this.decodeBit();
            }
            int i = 0;
            while (i < 8) {
                b |= this.decodeBit() << i;
                ++i;
            }
        }
        catch (EOFException e) {
            b = -1;
        }
        return b;
    }

    private int decodeBit() throws IOException {
        int bit = this.decodeCycle();
        int count = 1;
        while (bit == 0 && count < this.cycles0 || bit == 1 && count < this.cycles1) {
            int cycle = this.decodeCycle();
            if (cycle == bit) {
                ++count;
                continue;
            }
            bit = cycle;
            count = 1;
        }
        return bit;
    }

    private int decodeCycle() throws IOException {
        int hi;
        int result;
        int count = this.readCycle();
        int lo = Math.abs(count - this.countLo);
        int n = result = lo < (hi = Math.abs(count - this.countHi)) && lo < this.countLo / 2 ? 0 : 1;
        if (this.countAdapt) {
            if (result == 0 && lo < this.countLo / 2) {
                this.countLo = (this.countLo * 3 + count) / 4;
                this.countHi = this.countLo / 2;
            } else if (result == 1 && hi < this.countHi / 2) {
                this.countHi = (this.countHi * 3 + count) / 4;
                this.countLo = this.countHi * 2;
            }
        }
        return result;
    }

    public void decodeStart() throws IOException {
        this.countLo = (int)(this.audioFormat.getSampleRate() + 600.0f) / 1200;
        this.countHi = (int)(this.audioFormat.getSampleRate() + 1200.0f) / 2400;
    }

    public void decodeEnd() throws IOException {
    }
}

