/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UK101InputStream
extends InputStream {
    static final String NEWLINE = "\r\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\n";
    static final Pattern ESCAPE = Pattern.compile("\\\\([0-9A-F]{2})");
    private BufferedReader inputReader;
    private String line;
    private int lineLen;
    private int linePos;

    public UK101InputStream(Reader in) {
        this(new BufferedReader(in));
    }

    public UK101InputStream(BufferedReader in) {
        this.inputReader = in;
    }

    public int read() throws IOException {
        int ch = -1;
        if (this.line == null) {
            this.line = this.inputReader.readLine();
            if (this.line != null) {
                if (this.line.indexOf(92) != -1) {
                    StringBuffer sb = new StringBuffer();
                    Matcher m = ESCAPE.matcher(this.line);
                    while (m.find()) {
                        char codepoint = (char)Integer.parseInt(m.group(1), 16);
                        m.appendReplacement(sb, Character.toString(codepoint));
                    }
                    m.appendTail(sb);
                    this.line = sb.toString();
                }
                this.lineLen = this.line.length();
                this.linePos = 0;
            }
        }
        if (this.line != null) {
            if (this.linePos == this.lineLen) {
                this.line = NEWLINE;
                this.lineLen = this.line.length();
                this.linePos = 0;
            }
            ch = this.line.charAt(this.linePos++);
            if (this.line == NEWLINE && this.linePos == this.lineLen) {
                this.line = null;
            }
        }
        return ch;
    }

    public void close() throws IOException {
        this.inputReader.close();
    }
}

