/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import uk101.io.AudioEncoder;

public class WaveOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private AudioEncoder audioEncoder;
    private ByteArrayOutputStream audioStream;
    private boolean startStream;

    public WaveOutputStream(OutputStream out, AudioEncoder encoder) {
        this.outputStream = out;
        this.audioEncoder = encoder;
        this.audioStream = new ByteArrayOutputStream();
        this.audioEncoder.setOutputStream(this.audioStream);
        this.reset();
    }

    public void reset() {
        this.startStream = true;
    }

    public void write(int b) throws IOException {
        if (this.startStream) {
            this.audioEncoder.encodeStart();
            this.startStream = false;
        }
        this.audioEncoder.encodeByte(b);
    }

    public void close() throws IOException {
        if (this.audioStream.size() != 0) {
            this.audioEncoder.encodeEnd();
            ByteArrayInputStream in = new ByteArrayInputStream(this.audioStream.toByteArray());
            int frames = in.available() / this.audioEncoder.getFormat().getFrameSize();
            AudioInputStream audioIn = new AudioInputStream(in, this.audioEncoder.getFormat(), frames);
            AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, this.outputStream);
            audioIn.close();
        }
        this.outputStream.close();
    }
}

