/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk101.hardware.bus.IOBus;
import uk101.hardware.bus.IODevice;
import uk101.view.CassetteView;

public class TapeRecorder
implements IOBus {
    private IODevice acia;
    private InputStream input;
    private OutputStream output;
    private CassetteView view;

    public TapeRecorder(IODevice io) {
        this.acia = io;
    }

    public void setInputTape(InputStream in) {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.input = in;
        this.acia.setRxBus(in == null ? null : this);
    }

    public void setOutputTape(OutputStream out) {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.output = out;
        this.acia.setTxBus(out == null ? null : this);
    }

    public void shutdown() {
        this.setInputTape(null);
        this.setOutputTape(null);
    }

    public int readByte() {
        int b = -1;
        if (this.input != null) {
            try {
                b = this.input.read();
            }
            catch (IOException e) {
                System.err.println(e);
            }
            if (this.view != null) {
                this.view.setRead();
            }
        }
        return b;
    }

    public void writeByte(int value) {
        if (this.output != null) {
            try {
                this.output.write(value);
            }
            catch (IOException e) {
                System.err.println(e);
            }
            if (this.view != null) {
                this.view.setWrite();
            }
        }
    }

    public void setView(CassetteView view) {
        this.view = view;
    }

    public String toString() {
        return "Tape Recorder: input=" + this.input + " output=" + this.output;
    }
}

