/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import uk101.machine.Data;

public class Disassembler {
    public static final int MODE_IMPLICIT = 0;
    public static final int MODE_ACCUMULATOR = 1;
    public static final int MODE_IMMEDIATE = 2;
    public static final int MODE_RELATIVE = 3;
    public static final int MODE_ABSOLUTE = 4;
    public static final int MODE_INDIRECT = 5;
    public static final int MODE_ZEROPAGE = 6;
    public static final int MODE_ABS_X = 7;
    public static final int MODE_ABS_Y = 8;
    public static final int MODE_PRE_X = 9;
    public static final int MODE_POST_Y = 10;
    public static final int MODE_0PAGE_X = 11;
    public static final int MODE_0PAGE_Y = 12;
    public String instrText;
    public int instrOperand;
    public int instrMode;
    public int instrSize;
    private byte[] sourceBytes;
    private int sourceLength;
    private int sourceOrigin;
    private int origin;
    private int position;

    public Disassembler() {
        this(new byte[0], 0);
    }

    public Disassembler(byte[] bytes, int origin) {
        this.reset(bytes, bytes.length, 0, origin, origin);
    }

    public void reset(byte[] bytes, int length, int offset, int origin, int start) {
        this.sourceBytes = bytes;
        this.sourceLength = length;
        this.sourceOrigin = origin;
        this.position = start - origin + offset;
    }

    public boolean hasNext() {
        return this.position < this.sourceLength;
    }

    public String nextInstruction() {
        String result = "";
        if (this.hasNext()) {
            this.origin = this.sourceOrigin + this.position;
            this.decodeInstruction();
            this.decodeOperand();
            result = String.valueOf(Data.toHexString(this.origin)) + ":  ";
            int i = 0;
            while (i < this.instrSize) {
                result = String.valueOf(result) + Data.toHexString(this.sourceBytes[this.position + i]) + " ";
                ++i;
            }
            i = this.instrSize;
            while (i < 3) {
                result = String.valueOf(result) + "   ";
                ++i;
            }
            result = String.valueOf(result) + this.formatInstruction();
            this.position += this.instrSize;
        }
        return result;
    }

    private void decodeInstruction() {
        switch (Data.asBits(this.sourceBytes[this.position])) {
            default: {
                this.instrText = "???";
                this.instrMode = 0;
                break;
            }
            case 109: {
                this.instrText = "ADC";
                this.instrMode = 4;
                break;
            }
            case 101: {
                this.instrText = "ADC";
                this.instrMode = 6;
                break;
            }
            case 105: {
                this.instrText = "ADC";
                this.instrMode = 2;
                break;
            }
            case 125: {
                this.instrText = "ADC";
                this.instrMode = 7;
                break;
            }
            case 121: {
                this.instrText = "ADC";
                this.instrMode = 8;
                break;
            }
            case 97: {
                this.instrText = "ADC";
                this.instrMode = 9;
                break;
            }
            case 113: {
                this.instrText = "ADC";
                this.instrMode = 10;
                break;
            }
            case 117: {
                this.instrText = "ADC";
                this.instrMode = 11;
                break;
            }
            case 45: {
                this.instrText = "AND";
                this.instrMode = 4;
                break;
            }
            case 37: {
                this.instrText = "AND";
                this.instrMode = 6;
                break;
            }
            case 41: {
                this.instrText = "AND";
                this.instrMode = 2;
                break;
            }
            case 61: {
                this.instrText = "AND";
                this.instrMode = 7;
                break;
            }
            case 57: {
                this.instrText = "AND";
                this.instrMode = 8;
                break;
            }
            case 33: {
                this.instrText = "AND";
                this.instrMode = 9;
                break;
            }
            case 49: {
                this.instrText = "AND";
                this.instrMode = 10;
                break;
            }
            case 53: {
                this.instrText = "AND";
                this.instrMode = 11;
                break;
            }
            case 205: {
                this.instrText = "CMP";
                this.instrMode = 4;
                break;
            }
            case 197: {
                this.instrText = "CMP";
                this.instrMode = 6;
                break;
            }
            case 201: {
                this.instrText = "CMP";
                this.instrMode = 2;
                break;
            }
            case 221: {
                this.instrText = "CMP";
                this.instrMode = 7;
                break;
            }
            case 217: {
                this.instrText = "CMP";
                this.instrMode = 8;
                break;
            }
            case 193: {
                this.instrText = "CMP";
                this.instrMode = 9;
                break;
            }
            case 209: {
                this.instrText = "CMP";
                this.instrMode = 10;
                break;
            }
            case 213: {
                this.instrText = "CMP";
                this.instrMode = 11;
                break;
            }
            case 77: {
                this.instrText = "EOR";
                this.instrMode = 4;
                break;
            }
            case 69: {
                this.instrText = "EOR";
                this.instrMode = 6;
                break;
            }
            case 73: {
                this.instrText = "EOR";
                this.instrMode = 2;
                break;
            }
            case 93: {
                this.instrText = "EOR";
                this.instrMode = 7;
                break;
            }
            case 89: {
                this.instrText = "EOR";
                this.instrMode = 8;
                break;
            }
            case 65: {
                this.instrText = "EOR";
                this.instrMode = 9;
                break;
            }
            case 81: {
                this.instrText = "EOR";
                this.instrMode = 10;
                break;
            }
            case 85: {
                this.instrText = "EOR";
                this.instrMode = 11;
                break;
            }
            case 173: {
                this.instrText = "LDA";
                this.instrMode = 4;
                break;
            }
            case 165: {
                this.instrText = "LDA";
                this.instrMode = 6;
                break;
            }
            case 169: {
                this.instrText = "LDA";
                this.instrMode = 2;
                break;
            }
            case 189: {
                this.instrText = "LDA";
                this.instrMode = 7;
                break;
            }
            case 185: {
                this.instrText = "LDA";
                this.instrMode = 8;
                break;
            }
            case 161: {
                this.instrText = "LDA";
                this.instrMode = 9;
                break;
            }
            case 177: {
                this.instrText = "LDA";
                this.instrMode = 10;
                break;
            }
            case 181: {
                this.instrText = "LDA";
                this.instrMode = 11;
                break;
            }
            case 13: {
                this.instrText = "ORA";
                this.instrMode = 4;
                break;
            }
            case 5: {
                this.instrText = "ORA";
                this.instrMode = 6;
                break;
            }
            case 9: {
                this.instrText = "ORA";
                this.instrMode = 2;
                break;
            }
            case 29: {
                this.instrText = "ORA";
                this.instrMode = 7;
                break;
            }
            case 25: {
                this.instrText = "ORA";
                this.instrMode = 8;
                break;
            }
            case 1: {
                this.instrText = "ORA";
                this.instrMode = 9;
                break;
            }
            case 17: {
                this.instrText = "ORA";
                this.instrMode = 10;
                break;
            }
            case 21: {
                this.instrText = "ORA";
                this.instrMode = 11;
                break;
            }
            case 237: {
                this.instrText = "SBC";
                this.instrMode = 4;
                break;
            }
            case 229: {
                this.instrText = "SBC";
                this.instrMode = 6;
                break;
            }
            case 233: {
                this.instrText = "SBC";
                this.instrMode = 2;
                break;
            }
            case 253: {
                this.instrText = "SBC";
                this.instrMode = 7;
                break;
            }
            case 249: {
                this.instrText = "SBC";
                this.instrMode = 8;
                break;
            }
            case 225: {
                this.instrText = "SBC";
                this.instrMode = 9;
                break;
            }
            case 241: {
                this.instrText = "SBC";
                this.instrMode = 10;
                break;
            }
            case 245: {
                this.instrText = "SBC";
                this.instrMode = 11;
                break;
            }
            case 141: {
                this.instrText = "STA";
                this.instrMode = 4;
                break;
            }
            case 133: {
                this.instrText = "STA";
                this.instrMode = 6;
                break;
            }
            case 157: {
                this.instrText = "STA";
                this.instrMode = 7;
                break;
            }
            case 153: {
                this.instrText = "STA";
                this.instrMode = 8;
                break;
            }
            case 129: {
                this.instrText = "STA";
                this.instrMode = 9;
                break;
            }
            case 145: {
                this.instrText = "STA";
                this.instrMode = 10;
                break;
            }
            case 149: {
                this.instrText = "STA";
                this.instrMode = 11;
                break;
            }
            case 236: {
                this.instrText = "CPX";
                this.instrMode = 4;
                break;
            }
            case 228: {
                this.instrText = "CPX";
                this.instrMode = 6;
                break;
            }
            case 224: {
                this.instrText = "CPX";
                this.instrMode = 2;
                break;
            }
            case 204: {
                this.instrText = "CPY";
                this.instrMode = 4;
                break;
            }
            case 196: {
                this.instrText = "CPY";
                this.instrMode = 6;
                break;
            }
            case 192: {
                this.instrText = "CPY";
                this.instrMode = 2;
                break;
            }
            case 174: {
                this.instrText = "LDX";
                this.instrMode = 4;
                break;
            }
            case 166: {
                this.instrText = "LDX";
                this.instrMode = 6;
                break;
            }
            case 162: {
                this.instrText = "LDX";
                this.instrMode = 2;
                break;
            }
            case 190: {
                this.instrText = "LDX";
                this.instrMode = 8;
                break;
            }
            case 182: {
                this.instrText = "LDX";
                this.instrMode = 12;
                break;
            }
            case 172: {
                this.instrText = "LDY";
                this.instrMode = 4;
                break;
            }
            case 164: {
                this.instrText = "LDY";
                this.instrMode = 6;
                break;
            }
            case 160: {
                this.instrText = "LDY";
                this.instrMode = 2;
                break;
            }
            case 188: {
                this.instrText = "LDY";
                this.instrMode = 7;
                break;
            }
            case 180: {
                this.instrText = "LDY";
                this.instrMode = 11;
                break;
            }
            case 142: {
                this.instrText = "STX";
                this.instrMode = 4;
                break;
            }
            case 134: {
                this.instrText = "STX";
                this.instrMode = 6;
                break;
            }
            case 150: {
                this.instrText = "STX";
                this.instrMode = 12;
                break;
            }
            case 140: {
                this.instrText = "STY";
                this.instrMode = 4;
                break;
            }
            case 132: {
                this.instrText = "STY";
                this.instrMode = 6;
                break;
            }
            case 148: {
                this.instrText = "STY";
                this.instrMode = 11;
                break;
            }
            case 10: {
                this.instrText = "ASL";
                this.instrMode = 1;
                break;
            }
            case 14: {
                this.instrText = "ASL";
                this.instrMode = 4;
                break;
            }
            case 6: {
                this.instrText = "ASL";
                this.instrMode = 6;
                break;
            }
            case 30: {
                this.instrText = "ASL";
                this.instrMode = 7;
                break;
            }
            case 22: {
                this.instrText = "ASL";
                this.instrMode = 11;
                break;
            }
            case 74: {
                this.instrText = "LSR";
                this.instrMode = 1;
                break;
            }
            case 78: {
                this.instrText = "LSR";
                this.instrMode = 4;
                break;
            }
            case 70: {
                this.instrText = "LSR";
                this.instrMode = 6;
                break;
            }
            case 94: {
                this.instrText = "LSR";
                this.instrMode = 7;
                break;
            }
            case 86: {
                this.instrText = "LSR";
                this.instrMode = 11;
                break;
            }
            case 42: {
                this.instrText = "ROL";
                this.instrMode = 1;
                break;
            }
            case 46: {
                this.instrText = "ROL";
                this.instrMode = 4;
                break;
            }
            case 38: {
                this.instrText = "ROL";
                this.instrMode = 6;
                break;
            }
            case 62: {
                this.instrText = "ROL";
                this.instrMode = 7;
                break;
            }
            case 54: {
                this.instrText = "ROL";
                this.instrMode = 11;
                break;
            }
            case 106: {
                this.instrText = "ROR";
                this.instrMode = 1;
                break;
            }
            case 110: {
                this.instrText = "ROR";
                this.instrMode = 4;
                break;
            }
            case 102: {
                this.instrText = "ROR";
                this.instrMode = 6;
                break;
            }
            case 126: {
                this.instrText = "ROR";
                this.instrMode = 7;
                break;
            }
            case 118: {
                this.instrText = "ROR";
                this.instrMode = 11;
                break;
            }
            case 44: {
                this.instrText = "BIT";
                this.instrMode = 4;
                break;
            }
            case 36: {
                this.instrText = "BIT";
                this.instrMode = 6;
                break;
            }
            case 206: {
                this.instrText = "DEC";
                this.instrMode = 4;
                break;
            }
            case 198: {
                this.instrText = "DEC";
                this.instrMode = 6;
                break;
            }
            case 222: {
                this.instrText = "DEC";
                this.instrMode = 7;
                break;
            }
            case 214: {
                this.instrText = "DEC";
                this.instrMode = 11;
                break;
            }
            case 238: {
                this.instrText = "INC";
                this.instrMode = 4;
                break;
            }
            case 230: {
                this.instrText = "INC";
                this.instrMode = 6;
                break;
            }
            case 254: {
                this.instrText = "INC";
                this.instrMode = 7;
                break;
            }
            case 246: {
                this.instrText = "INC";
                this.instrMode = 11;
                break;
            }
            case 202: {
                this.instrText = "DEX";
                this.instrMode = 0;
                break;
            }
            case 136: {
                this.instrText = "DEY";
                this.instrMode = 0;
                break;
            }
            case 232: {
                this.instrText = "INX";
                this.instrMode = 0;
                break;
            }
            case 200: {
                this.instrText = "INY";
                this.instrMode = 0;
                break;
            }
            case 170: {
                this.instrText = "TAX";
                this.instrMode = 0;
                break;
            }
            case 168: {
                this.instrText = "TAY";
                this.instrMode = 0;
                break;
            }
            case 186: {
                this.instrText = "TSX";
                this.instrMode = 0;
                break;
            }
            case 138: {
                this.instrText = "TXA";
                this.instrMode = 0;
                break;
            }
            case 154: {
                this.instrText = "TXS";
                this.instrMode = 0;
                break;
            }
            case 152: {
                this.instrText = "TYA";
                this.instrMode = 0;
                break;
            }
            case 144: {
                this.instrText = "BCC";
                this.instrMode = 3;
                break;
            }
            case 176: {
                this.instrText = "BCS";
                this.instrMode = 3;
                break;
            }
            case 240: {
                this.instrText = "BEQ";
                this.instrMode = 3;
                break;
            }
            case 48: {
                this.instrText = "BMI";
                this.instrMode = 3;
                break;
            }
            case 208: {
                this.instrText = "BNE";
                this.instrMode = 3;
                break;
            }
            case 16: {
                this.instrText = "BPL";
                this.instrMode = 3;
                break;
            }
            case 80: {
                this.instrText = "BVC";
                this.instrMode = 3;
                break;
            }
            case 112: {
                this.instrText = "BVS";
                this.instrMode = 3;
                break;
            }
            case 24: {
                this.instrText = "CLC";
                this.instrMode = 0;
                break;
            }
            case 216: {
                this.instrText = "CLD";
                this.instrMode = 0;
                break;
            }
            case 88: {
                this.instrText = "CLI";
                this.instrMode = 0;
                break;
            }
            case 184: {
                this.instrText = "CLO";
                this.instrMode = 0;
                break;
            }
            case 56: {
                this.instrText = "SEC";
                this.instrMode = 0;
                break;
            }
            case 248: {
                this.instrText = "SED";
                this.instrMode = 0;
                break;
            }
            case 120: {
                this.instrText = "SEI";
                this.instrMode = 0;
                break;
            }
            case 234: {
                this.instrText = "NOP";
                this.instrMode = 0;
                break;
            }
            case 72: {
                this.instrText = "PHA";
                this.instrMode = 0;
                break;
            }
            case 8: {
                this.instrText = "PHP";
                this.instrMode = 0;
                break;
            }
            case 104: {
                this.instrText = "PLA";
                this.instrMode = 0;
                break;
            }
            case 40: {
                this.instrText = "PLP";
                this.instrMode = 0;
                break;
            }
            case 0: {
                this.instrText = "BRK";
                this.instrMode = 0;
                break;
            }
            case 76: {
                this.instrText = "JMP";
                this.instrMode = 4;
                break;
            }
            case 108: {
                this.instrText = "JMP";
                this.instrMode = 5;
                break;
            }
            case 32: {
                this.instrText = "JSR";
                this.instrMode = 4;
                break;
            }
            case 64: {
                this.instrText = "RTI";
                this.instrMode = 0;
                break;
            }
            case 96: {
                this.instrText = "RTS";
                this.instrMode = 0;
            }
        }
    }

    private void decodeOperand() {
        switch (this.instrMode) {
            default: {
                this.instrSize = 1;
                break;
            }
            case 2: {
                this.instrSize = 2;
                break;
            }
            case 4: {
                this.instrSize = 3;
                break;
            }
            case 5: {
                this.instrSize = 3;
                break;
            }
            case 6: {
                this.instrSize = 2;
                break;
            }
            case 3: {
                this.instrSize = 2;
                break;
            }
            case 7: {
                this.instrSize = 3;
                break;
            }
            case 8: {
                this.instrSize = 3;
                break;
            }
            case 9: {
                this.instrSize = 2;
                break;
            }
            case 10: {
                this.instrSize = 2;
                break;
            }
            case 11: {
                this.instrSize = 2;
                break;
            }
            case 12: {
                this.instrSize = 2;
            }
        }
        if (this.instrSize > 1) {
            if (this.position + this.instrSize <= this.sourceLength) {
                if (this.instrSize == 2) {
                    byte lo = this.sourceBytes[this.position + 1];
                    this.instrOperand = Data.asAddr(lo);
                } else if (this.instrSize == 3) {
                    byte lo = this.sourceBytes[this.position + 1];
                    byte hi = this.sourceBytes[this.position + 2];
                    this.instrOperand = Data.asAddr(Data.getWord(hi, lo));
                }
            } else {
                this.instrText = "!!!";
                this.instrMode = 0;
                this.instrSize = 1;
            }
        }
    }

    private String formatInstruction() {
        String result = "  " + this.instrText + " ";
        switch (this.instrMode) {
            default: {
                break;
            }
            case 1: {
                result = String.valueOf(result) + "A";
                break;
            }
            case 2: {
                result = String.valueOf(result) + "#$" + Data.toHexString((byte)this.instrOperand);
                break;
            }
            case 4: {
                result = String.valueOf(result) + "$" + Data.toHexString((short)this.instrOperand);
                break;
            }
            case 5: {
                result = String.valueOf(result) + "($" + Data.toHexString((short)this.instrOperand) + ")";
                break;
            }
            case 6: {
                result = String.valueOf(result) + "$" + Data.toHexString((byte)this.instrOperand);
                break;
            }
            case 3: {
                result = String.valueOf(result) + "$" + Data.toHexString(this.origin + (byte)this.instrOperand + 2);
                break;
            }
            case 7: {
                result = String.valueOf(result) + "$" + Data.toHexString((short)this.instrOperand) + ",X";
                break;
            }
            case 8: {
                result = String.valueOf(result) + "$" + Data.toHexString((short)this.instrOperand) + ",Y";
                break;
            }
            case 9: {
                result = String.valueOf(result) + "($" + Data.toHexString((byte)this.instrOperand) + ",X)";
                break;
            }
            case 10: {
                result = String.valueOf(result) + "($" + Data.toHexString((byte)this.instrOperand) + "),Y";
                break;
            }
            case 11: {
                result = String.valueOf(result) + "$" + Data.toHexString((byte)this.instrOperand) + ",X";
                break;
            }
            case 12: {
                result = String.valueOf(result) + "$" + Data.toHexString((byte)this.instrOperand) + ",Y";
            }
        }
        return result;
    }
}

