/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import uk101.machine.Dump;
import uk101.utils.Args;
import uk101.utils.PrintBytes;
import uk101.utils.PrintCode;

public class PrintDump {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("output", "outputfile");
        options.put("hex");
        options.put("code");
        Args parms = new Args(PrintDump.class, "dumpfile", args, options);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile("output");
        boolean asHex = parms.getFlag("hex");
        boolean asCode = parms.getFlag("code");
        if (inputFile == null || asHex && asCode) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        Dump dump = Dump.readDump(inputFile);
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        if (dump != null) {
            output.println("UK101 Memory Dump");
            output.println("created: " + df.format(dump.timestamp));
            ByteArrayInputStream bytes = new ByteArrayInputStream(dump.store);
            output.println();
            if (asCode) {
                new PrintCode(output).print(0, bytes);
            } else {
                new PrintBytes(output).print(0, bytes);
            }
            output.println();
        }
    }
}

